import { Integration, SentryEvent } from '@sentry/types';
/** JSDoc */
interface InboundFiltersOptions {
    ignoreErrors?: Array<string | RegExp>;
    blacklistUrls?: Array<string | RegExp>;
    whitelistUrls?: Array<string | RegExp>;
}
/** Inbound filters configurable by the user */
export declare class InboundFilters implements Integration {
    private readonly options;
    /** JSDoc */
    private ignoreErrors?;
    /** JSDoc */
    private blacklistUrls?;
    /** JSDoc */
    private whitelistUrls?;
    /**
     * @inheritDoc
     */
    name: string;
    /**
     * @inheritDoc
     */
    static id: string;
    constructor(options?: InboundFiltersOptions);
    /**
     * @inheritDoc
     */
    setupOnce(): void;
    /** JSDoc */
    shouldDropEvent(event: SentryEvent): boolean;
    /** JSDoc */
    isIgnoredError(event: SentryEvent): boolean;
    /** JSDoc */
    isBlacklistedUrl(event: SentryEvent): boolean;
    /** JSDoc */
    isWhitelistedUrl(event: SentryEvent): boolean;
    /** JSDoc */
    private isMatchingPattern;
    /** JSDoc */
    private configureOptions;
    /** JSDoc */
    private getPossibleEventMessages;
    /** JSDoc */
    private getEventFilterUrl;
}
export {};
