import { CallGraphResult, DepGraph, DepTree, ScannedProject, SupportedPackageManagers } from './common';
export interface SingleSubprojectPlugin {
    inspect(root: string, targetFile?: string, options?: SingleSubprojectInspectOptions): Promise<SinglePackageResult>;
    pluginName?(): string;
}
export interface Plugin extends SingleSubprojectPlugin {
    inspect(root: string, targetFile?: string, options?: InspectOptions): Promise<InspectResult>;
    inspect(root: string, targetFile?: string, options?: SingleSubprojectInspectOptions): Promise<SinglePackageResult>;
    inspect(root: string, targetFile: string | undefined, options: MultiSubprojectInspectOptions): Promise<MultiProjectResult>;
}
export declare function adaptSingleProjectPlugin(plugin: SingleSubprojectPlugin): Plugin;
export interface BaseInspectOptions {
    dev?: boolean;
    skipUnresolved?: boolean;
    args?: string[];
    useDepGraph?: boolean;
}
export interface SingleSubprojectInspectOptions extends BaseInspectOptions {
    subProject?: string;
}
export interface MultiSubprojectInspectOptions extends BaseInspectOptions {
    allSubProjects: true;
}
export declare type InspectOptions = SingleSubprojectInspectOptions | MultiSubprojectInspectOptions;
export declare type InspectResult = SinglePackageResult | MultiProjectResult;
export declare function isMultiSubProject(options: InspectOptions): options is MultiSubprojectInspectOptions;
export interface PluginMetadata {
    name: string;
    runtime?: string;
    targetFile?: string;
    packageManager?: SupportedPackageManagers;
    meta?: {
        allSubProjectNames?: string[];
        versionBuildInfo?: VersionBuildInfo;
        targetFile?: string;
    };
    dockerImageId?: any;
    imageLayers?: any;
    packageFormatVersion?: string;
}
export interface VersionBuildInfo {
    gradleVersion?: string;
    metaBuildVersion: {
        [index: string]: string;
    };
}
export interface SinglePackageResult {
    plugin: PluginMetadata;
    package: DepTree;
    dependencyGraph?: DepGraph;
    callGraph?: CallGraphResult;
    meta?: {
        gradleProjectName?: string;
        versionBuildInfo?: VersionBuildInfo;
    };
}
export interface MultiProjectResult {
    plugin: PluginMetadata;
    scannedProjects: ScannedProject[];
}
export declare function isMultiResult(res: InspectResult): res is MultiProjectResult;
