import * as graphlib from 'graphlib';
import * as types from './types';
export { DepGraphImpl };
declare class DepGraphImpl implements types.DepGraphInternal {
    static SCHEMA_VERSION: string;
    static getPkgId(pkg: types.Pkg): string;
    private _pkgs;
    private _pkgNodes;
    private _pkgList;
    private _depPkgsList;
    private _graph;
    private _pkgManager;
    private _rootNodeId;
    private _rootPkgId;
    private _countNodePathsToRootCache;
    private _hasCycles;
    constructor(graph: graphlib.Graph, rootNodeId: string, pkgs: {
        [pkgId: string]: types.PkgInfo;
    }, pkgNodes: {
        [pkgId: string]: Set<string>;
    }, pkgManager: types.PkgManager);
    get pkgManager(): types.PkgManager;
    get rootPkg(): types.PkgInfo;
    get rootNodeId(): string;
    getPkgs(): types.PkgInfo[];
    getDepPkgs(): types.PkgInfo[];
    getPkgNodes(pkg: types.Pkg): types.Node[];
    getNode(nodeId: string): types.NodeInfo;
    getNodePkg(nodeId: string): types.PkgInfo;
    getPkgNodeIds(pkg: types.Pkg): string[];
    getNodeDepsNodeIds(nodeId: string): string[];
    getNodeParentsNodeIds(nodeId: string): string[];
    hasCycles(): boolean;
    pkgPathsToRoot(pkg: types.Pkg): types.PkgInfo[][];
    countPathsToRoot(pkg: types.Pkg): number;
    equals(other: types.DepGraph, { compareRoot }?: {
        compareRoot?: boolean;
    }): boolean;
    directDepsLeadingTo(pkg: types.Pkg): types.PkgInfo[];
    toJSON(): types.DepGraphData;
    private nodeEquals;
    private getGraphNode;
    private pathsFromNodeToRoot;
    private countNodePathsToRoot;
}
