# snyk/docker-registry-v2-client

Docker Registry HTTP V2 TypeScript client for read operations:

```
getRepos        _catalog
getTags         <repository>/tags/list
getManifest     <repository>/manifests/<tag>
getImageConfig  <repository>/blobs/<image digest> (application/vnd.docker.container.image.v1+json)
getLayer        <repository>/blobs/<layer digest> (application/vnd.docker.image.rootfs.diff.tar.gzip)
```

REPL example:

```
> import { getRepos } from "docker-registry-v2-client";
> (async () => await getRepos('snykgoof.azurecr.io', 'snykgoof', *****))().then((res) => console.log(res))
...
> [ { namespace: 'snykgoof', name: 'azure-goof' } ]
```

### Tests

Set up your local env with the following env vars (see 1Password):
```console
export SNYK_DRA_AZURE_USERNAME=snykgoof
export SNYK_DRA_AZURE_PASSWORD=<See 1password: Development/Azure Container Registry (ACR) - Docker Registry Agent>
export SNYK_DRA_AZURE_REPOSITORY=snykgoof/azure-goof
export SNYK_DRA_AZURE_REGISTRY_BASE=snykgoof.azurecr.io

export SNYK_DRA_DOCKER_HUB_USERNAME=snykgoof
export SNYK_DRA_DOCKER_HUB_PASSWORD=<See 1password: Docker - snykgoof user>
export SNYK_DRA_DOCKER_HUB_REPOSITORY=snykgoof/dockerhub-goof
export SNYK_DRA_DOCKER_HUB_REGISTRY_BASE=registry-1.docker.io

export SNYK_DRA_ELASTIC_ACCESS_KEY_ID=AKIAJICAGDWS3GILA5WA
export SNYK_DRA_ELASTIC_SECRET_ACCESS_KEY=<See 1password: Development/Elastic Container Registry (ECR) - Docker Registry Agent>
export SNYK_DRA_ELASTIC_REGION=eu-west-3
export SNYK_DRA_ELASTIC_REPOSITORY=amazon-goof

export SNYK_DRA_ARTIFACTORY_USERNAME=snyk-e2e-test
export SNYK_DRA_ARTIFACTORY_PASSWORD=<See 1password: Artifactory Cloud - snyk-e2e-test>
export SNYK_DRA_ARTIFACTORY_REPOSITORY=goof
export SNYK_DRA_ARTIFACTORY_REGISTRY_BASE=snyk-test-registry.jfrog.io
```
To run the tests:

```console
$ npm run test
```

Open `coverage/index.html` in your web browser to view the coverage reports

### Linting and formatting

> Note: Linting tasks are also run as part of the test run. However, due to
> their execution speed, it can be useful to run them as you develop, to keep
> your code organised.

To run the code formatting tasks:

```console
$ npm run format
```

To run the linting tasks:

```console
$ npm run lint
```
