"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const gem_version_1 = require("./ruby/gem-version");
const inc = () => {
    throw new Error('Not implemented');
};
exports.inc = inc;
function valid(v) {
    if (!v) {
        return null;
    }
    try {
        return gem_version_1.GemVersion.create(v).toString();
    }
    catch (err) {
        return null;
    }
}
exports.valid = valid;
function prerelease(v) {
    try {
        const version = gem_version_1.GemVersion.create(v);
        if (version.isPrerelease()) {
            const segments = version.getSegments();
            const preStartIndex = segments.findIndex((s) => typeof s === 'string' && /[a-zA-Z]/.test(s));
            return segments.slice(preStartIndex);
        }
        else {
            return null;
        }
    }
    catch (err) {
        return null;
    }
}
exports.prerelease = prerelease;
function _segmentAt(v, index) {
    try {
        const segment = gem_version_1.GemVersion.create(v).getSegments()[index];
        return segment === undefined ? null : segment;
    }
    catch (err) {
        return null;
    }
}
function major(v) {
    return _segmentAt(v, 0);
}
exports.major = major;
function minor(v) {
    return _segmentAt(v, 1);
}
exports.minor = minor;
function patch(v) {
    return _segmentAt(v, 2);
}
exports.patch = patch;
//# sourceMappingURL=functions.js.map