import test from 'ava';

import { maxSatisfying } from '../../';

// maxSatisfying(versions, range): Return the highest version in the list that
// satisfies the range, or null if none of them do.

test('maxSatisfying(versions, range)', (t) => {
  t.is(maxSatisfying(['1.2.3', '1.2.4'], '~> 1.2'), '1.2.4');
  t.is(maxSatisfying(['1.2.3', '1.2.4', '1.2.5'], '~> 1.2, <= 1.2.4'), '1.2.4');
  t.is(maxSatisfying(['1.2.4', '1.2.3'], '~> 1.2'), '1.2.4');
  t.is(
    maxSatisfying(['1.2.3', '1.2.4', '1.2.5', '1.2.6'], '~> 1.2.3'),
    '1.2.6',
  );
  t.is(
    maxSatisfying(
      [
        '1.1.0',
        '1.2.0',
        '1.2.1',
        '1.3.0',
        '2.0.0b1',
        '2.0.0b2',
        '2.0.0b3',
        '2.0.0',
        '2.1.0',
      ],
      '~> 2.0.0',
    ),
    '2.0.0',
  );

  t.is(maxSatisfying(['1.2.3', '1.2.4'], '> 3.2'), null);
});
