export declare type MaybeGemVersion = GemVersion | string;
export declare type Ordering = 1 | 0 | -1;
export declare class GemVersion {
    version: string;
    _release?: GemVersion;
    _isPrerelease?: boolean;
    _bump?: GemVersion;
    static VERSION_PATTERN: any;
    toString(): string;
    static isCorrect(version: string): boolean;
    static create(input: MaybeGemVersion): GemVersion | undefined;
    constructor(version: string);
    bump(): GemVersion;
    isIdentical(other: unknown): boolean;
    isPrerelease(): boolean;
    release(): GemVersion;
    getSegments(): Array<string | number>;
    compare(other: GemVersion): Ordering;
    compare(other: unknown): undefined;
}
