'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.buildTokenList = buildTokenList;
/* babel-plugin-inline-import './lib/Solidity.tokens' */var tokens = 'T__0=1\nT__1=2\nT__2=3\nT__3=4\nT__4=5\nT__5=6\nT__6=7\nT__7=8\nT__8=9\nT__9=10\nT__10=11\nT__11=12\nT__12=13\nT__13=14\nT__14=15\nT__15=16\nT__16=17\nT__17=18\nT__18=19\nT__19=20\nT__20=21\nT__21=22\nT__22=23\nT__23=24\nT__24=25\nT__25=26\nT__26=27\nT__27=28\nT__28=29\nT__29=30\nT__30=31\nT__31=32\nT__32=33\nT__33=34\nT__34=35\nT__35=36\nT__36=37\nT__37=38\nT__38=39\nT__39=40\nT__40=41\nT__41=42\nT__42=43\nT__43=44\nT__44=45\nT__45=46\nT__46=47\nT__47=48\nT__48=49\nT__49=50\nT__50=51\nT__51=52\nT__52=53\nT__53=54\nT__54=55\nT__55=56\nT__56=57\nT__57=58\nT__58=59\nT__59=60\nT__60=61\nT__61=62\nT__62=63\nT__63=64\nT__64=65\nT__65=66\nT__66=67\nT__67=68\nT__68=69\nT__69=70\nT__70=71\nT__71=72\nT__72=73\nT__73=74\nT__74=75\nT__75=76\nT__76=77\nT__77=78\nT__78=79\nT__79=80\nT__80=81\nT__81=82\nT__82=83\nT__83=84\nT__84=85\nT__85=86\nT__86=87\nT__87=88\nT__88=89\nT__89=90\nT__90=91\nT__91=92\nT__92=93\nT__93=94\nInt=95\nUint=96\nByte=97\nFixed=98\nUfixed=99\nBooleanLiteral=100\nDecimalNumber=101\nHexNumber=102\nNumberUnit=103\nHexLiteral=104\nReservedKeyword=105\nAnonymousKeyword=106\nBreakKeyword=107\nConstantKeyword=108\nImmutableKeyword=109\nContinueKeyword=110\nLeaveKeyword=111\nExternalKeyword=112\nIndexedKeyword=113\nInternalKeyword=114\nPayableKeyword=115\nPrivateKeyword=116\nPublicKeyword=117\nVirtualKeyword=118\nPureKeyword=119\nTypeKeyword=120\nViewKeyword=121\nConstructorKeyword=122\nFallbackKeyword=123\nReceiveKeyword=124\nIdentifier=125\nStringLiteralFragment=126\nVersionLiteral=127\nWS=128\nCOMMENT=129\nLINE_COMMENT=130\n\'pragma\'=1\n\';\'=2\n\'^\'=3\n\'~\'=4\n\'>=\'=5\n\'>\'=6\n\'<\'=7\n\'<=\'=8\n\'=\'=9\n\'as\'=10\n\'import\'=11\n\'*\'=12\n\'from\'=13\n\'{\'=14\n\',\'=15\n\'}\'=16\n\'abstract\'=17\n\'contract\'=18\n\'interface\'=19\n\'library\'=20\n\'is\'=21\n\'(\'=22\n\')\'=23\n\'using\'=24\n\'for\'=25\n\'struct\'=26\n\'modifier\'=27\n\'function\'=28\n\'returns\'=29\n\'event\'=30\n\'enum\'=31\n\'[\'=32\n\']\'=33\n\'address\'=34\n\'.\'=35\n\'mapping\'=36\n\'=>\'=37\n\'memory\'=38\n\'storage\'=39\n\'calldata\'=40\n\'if\'=41\n\'else\'=42\n\'try\'=43\n\'catch\'=44\n\'while\'=45\n\'assembly\'=46\n\'do\'=47\n\'return\'=48\n\'throw\'=49\n\'emit\'=50\n\'var\'=51\n\'bool\'=52\n\'string\'=53\n\'byte\'=54\n\'++\'=55\n\'--\'=56\n\'new\'=57\n\':\'=58\n\'+\'=59\n\'-\'=60\n\'after\'=61\n\'delete\'=62\n\'!\'=63\n\'**\'=64\n\'/\'=65\n\'%\'=66\n\'<<\'=67\n\'>>\'=68\n\'&\'=69\n\'|\'=70\n\'==\'=71\n\'!=\'=72\n\'&&\'=73\n\'||\'=74\n\'?\'=75\n\'|=\'=76\n\'^=\'=77\n\'&=\'=78\n\'<<=\'=79\n\'>>=\'=80\n\'+=\'=81\n\'-=\'=82\n\'*=\'=83\n\'/=\'=84\n\'%=\'=85\n\'let\'=86\n\':=\'=87\n\'=:\'=88\n\'switch\'=89\n\'case\'=90\n\'default\'=91\n\'->\'=92\n\'callback\'=93\n\'override\'=94\n\'anonymous\'=106\n\'break\'=107\n\'constant\'=108\n\'immutable\'=109\n\'continue\'=110\n\'leave\'=111\n\'external\'=112\n\'indexed\'=113\n\'internal\'=114\n\'payable\'=115\n\'private\'=116\n\'public\'=117\n\'virtual\'=118\n\'pure\'=119\n\'type\'=120\n\'view\'=121\n\'constructor\'=122\n\'fallback\'=123\n\'receive\'=124\n';


var TYPE_TOKENS = ['var', 'bool', 'address', 'string', 'Int', 'Uint', 'Byte', 'Fixed', 'UFixed'];

function rsplit(str, value) {
  var index = str.lastIndexOf(value);
  return [str.substring(0, index), str.substring(index + 1, str.length)];
}

function normalizeTokenType(value) {
  if (value.endsWith("'")) {
    value = value.substring(0, value.length - 1);
  }
  if (value.startsWith("'")) {
    value = value.substring(1, value.length);
  }
  return value;
}

function getTokenType(value) {
  if (value === 'Identifier' || value === 'from') {
    return 'Identifier';
  } else if (value === 'TrueLiteral' || value === 'FalseLiteral') {
    return 'Boolean';
  } else if (value === 'VersionLiteral') {
    return 'Version';
  } else if (value === 'StringLiteral') {
    return 'String';
  } else if (TYPE_TOKENS.includes(value)) {
    return 'Type';
  } else if (value === 'NumberUnit') {
    return 'Subdenomination';
  } else if (value === 'DecimalNumber') {
    return 'Numeric';
  } else if (value === 'HexLiteral') {
    return 'Hex';
  } else if (value === 'ReservedKeyword') {
    return 'Reserved';
  } else if (/^\W+$/.test(value)) {
    return 'Punctuator';
  } else {
    return 'Keyword';
  }
}

function getTokenTypeMap() {
  return tokens.split('\n').map(function (line) {
    return rsplit(line, '=');
  }).reduce(function (acum, _ref) {
    var _ref2 = _slicedToArray(_ref, 2),
        value = _ref2[0],
        key = _ref2[1];

    acum[parseInt(key, 10)] = normalizeTokenType(value);
    return acum;
  }, {});
}

function buildTokenList(tokens, options) {
  var tokenTypes = getTokenTypeMap();

  return tokens.map(function (token) {
    var type = getTokenType(tokenTypes[token.type]);
    var node = { type: type, value: token.text };
    if (options.range) {
      node.range = [token.start, token.stop + 1];
    }
    if (options.loc) {
      node.loc = {
        start: { line: token.line, column: token.column },
        end: { line: token.line, column: token.column + token.text.length }
      };
    }
    return node;
  });
}