import EventEmitter from 'eventemitter3';
import { ChannelProviderInterface, OnType, OffType, EventType, WalletJsonRpcAPI } from '@statechannels/iframe-channel-provider';
import { ChannelResult, CloseChannelParams, CreateChannelParams, GetStateParams, JoinChannelParams, PushMessageResult, DomainBudget, UpdateChannelParams, Message } from '@statechannels/client-api-schema';
declare type ChannelId = string;
export declare class FakeChannelProvider implements ChannelProviderInterface {
    signingAddress?: string;
    destinationAddress?: string;
    walletVersion?: string;
    protected events: EventEmitter<EventType>;
    protected url: string;
    playerIndex: Record<ChannelId, 0 | 1>;
    opponentIndex: Record<ChannelId, 0 | 1>;
    internalAddress: string;
    opponentAddress: Record<ChannelId, string>;
    latestState: Record<ChannelId, ChannelResult>;
    send<M extends keyof WalletJsonRpcAPI>(method: M, params: WalletJsonRpcAPI[M]['request']['params']): Promise<WalletJsonRpcAPI[M]['response']['result']>;
    on: OnType;
    off: OffType;
    subscribe(): Promise<string>;
    unsubscribe(): Promise<boolean>;
    setState(state: ChannelResult): void;
    setAddress(address: string): void;
    updatePlayerIndex(channelId: ChannelId, playerIndex: 0 | 1): void;
    protected getAddress(): string;
    protected getPlayerIndex(channelId: ChannelId): number;
    getOpponentIndex(channelId: ChannelId): number;
    verifyTurnNum(channelId: ChannelId, turnNum: number): Promise<void>;
    findChannel(channelId: string): ChannelResult;
    protected createChannel(params: CreateChannelParams): Promise<ChannelResult>;
    protected joinChannel(params: JoinChannelParams): Promise<ChannelResult>;
    protected getState({ channelId }: GetStateParams): Promise<ChannelResult>;
    protected updateChannel(params: UpdateChannelParams): Promise<ChannelResult>;
    protected closeChannel(params: CloseChannelParams): Promise<ChannelResult>;
    protected notifyAppChannelUpdated(data: ChannelResult): void;
    protected notifyAppBudgetUpdated(data: DomainBudget): void;
    protected notifyOpponent(data: ChannelResult, notificationType: string): void;
    protected isChannelResult(data: unknown): data is ChannelResult;
    protected pushMessage(params: Message): Promise<PushMessageResult>;
}
export {};
//# sourceMappingURL=fake-channel-provider.d.ts.map