## API Report File for "@statechannels/iframe-channel-provider"

> Do not edit this file. It is a report generated by [API Extractor](https://api-extractor.com/).

```ts

import { ApproveBudgetAndFundRequest } from '@statechannels/client-api-schema';
import { ApproveBudgetAndFundResponse } from '@statechannels/client-api-schema';
import { ChallengeChannelRequest } from '@statechannels/client-api-schema';
import { ChallengeChannelResponse } from '@statechannels/client-api-schema';
import { CloseAndWithdrawRequest } from '@statechannels/client-api-schema';
import { CloseAndWithdrawResponse } from '@statechannels/client-api-schema';
import { CloseChannelRequest } from '@statechannels/client-api-schema';
import { CloseChannelResponse } from '@statechannels/client-api-schema';
import { CreateChannelRequest } from '@statechannels/client-api-schema';
import { CreateChannelResponse } from '@statechannels/client-api-schema';
import { EnableEthereumRequest } from '@statechannels/client-api-schema';
import { EnableEthereumResponse } from '@statechannels/client-api-schema';
import EventEmitter from 'eventemitter3';
import { GetBudgetRequest } from '@statechannels/client-api-schema';
import { GetBudgetResponse } from '@statechannels/client-api-schema';
import { GetChannelsRequest } from '@statechannels/client-api-schema';
import { GetChannelsResponse } from '@statechannels/client-api-schema';
import { GetStateRequest } from '@statechannels/client-api-schema';
import { GetStateResponse } from '@statechannels/client-api-schema';
import { GetWalletInformationRequest } from '@statechannels/client-api-schema';
import { GetWalletInformationResponse } from '@statechannels/client-api-schema';
import { JoinChannelRequest } from '@statechannels/client-api-schema';
import { JoinChannelResponse } from '@statechannels/client-api-schema';
import { JsonRpcRequest } from '@statechannels/client-api-schema';
import { PushMessageRequest } from '@statechannels/client-api-schema';
import { PushMessageResponse } from '@statechannels/client-api-schema';
import { StateChannelsNotification } from '@statechannels/client-api-schema';
import { StateChannelsNotificationType } from '@statechannels/client-api-schema';
import { StateChannelsResponse } from '@statechannels/client-api-schema';
import { UpdateChannelRequest } from '@statechannels/client-api-schema';
import { UpdateChannelResponse } from '@statechannels/client-api-schema';

// @beta
export const channelProvider: IFrameChannelProvider;

// @beta
export interface ChannelProviderInterface {
    destinationAddress?: string;
    // Warning: (ae-incompatible-release-tags) The symbol "off" is marked as @beta, but its signature references "OffType" which is marked as @internal
    off: OffType;
    // Warning: (ae-incompatible-release-tags) The symbol "on" is marked as @beta, but its signature references "OnType" which is marked as @internal
    on: OnType;
    send<MethodName extends keyof WalletJsonRpcAPI>(method: MethodName, params: WalletJsonRpcAPI[MethodName]['request']['params']): Promise<WalletJsonRpcAPI[MethodName]['response']['result']>;
    signingAddress?: string;
    // Warning: (ae-incompatible-release-tags) The symbol "subscribe" is marked as @beta, but its signature references "SubscribeType" which is marked as @internal
    //
    // (undocumented)
    subscribe: SubscribeType;
    // Warning: (ae-incompatible-release-tags) The symbol "unsubscribe" is marked as @beta, but its signature references "UnsubscribeType" which is marked as @internal
    //
    // (undocumented)
    unsubscribe: UnsubscribeType;
    walletVersion?: string;
}

// Warning: (ae-internal-missing-underscore) The name "EventType" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal
export interface EventType extends StateChannelsNotificationType {
    // (undocumented)
    [id: string]: [unknown];
}

// @beta
export class IFrameChannelProvider implements IFrameChannelProviderInterface {
    constructor();
    destinationAddress?: string;
    enable(): Promise<void>;
    // Warning: (ae-incompatible-release-tags) The symbol "events" is marked as @beta, but its signature references "EventType" which is marked as @internal
    protected readonly events: EventEmitter<EventType>;
    // Warning: (ae-forgotten-export) The symbol "IFrameService" needs to be exported by the entry point index.d.ts
    protected readonly iframe: IFrameService;
    // Warning: (ae-forgotten-export) The symbol "PostMessageService" needs to be exported by the entry point index.d.ts
    protected readonly messaging: PostMessageService;
    protected mounted: boolean;
    mountWalletComponent(url: string): Promise<void>;
    // Warning: (ae-incompatible-release-tags) The symbol "off" is marked as @beta, but its signature references "OffType" which is marked as @internal
    off: OffType;
    // Warning: (ae-incompatible-release-tags) The symbol "on" is marked as @beta, but its signature references "OnType" which is marked as @internal
    on: OnType;
    // (undocumented)
    protected onMessage(event: MessageEvent): Promise<void>;
    // (undocumented)
    send<M extends keyof WalletJsonRpcAPI>(method: M, params: WalletJsonRpcAPI[M]['request']['params']): Promise<WalletJsonRpcAPI[M]['response']['result']>;
    signingAddress?: string;
    // Warning: (ae-incompatible-release-tags) The symbol "subscribe" is marked as @beta, but its signature references "SubscribeType" which is marked as @internal
    //
    // (undocumented)
    subscribe: SubscribeType;
    // (undocumented)
    protected readonly subscriptions: {
        [T in keyof StateChannelsNotificationType]: string[];
    };
    // Warning: (ae-incompatible-release-tags) The symbol "unsubscribe" is marked as @beta, but its signature references "UnsubscribeType" which is marked as @internal
    //
    // (undocumented)
    unsubscribe: UnsubscribeType;
    protected url: string;
    walletReady: (url: string) => Promise<unknown>;
    walletVersion?: string;
}

// @beta
export interface IFrameChannelProviderInterface extends Web3ChannelProviderInterface {
    mountWalletComponent(url?: string): Promise<void>;
}

// Warning: (ae-forgotten-export) The symbol "eventEmitter" needs to be exported by the entry point index.d.ts
// Warning: (ae-internal-missing-underscore) The name "OffType" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type OffType = typeof eventEmitter.off;

// Warning: (ae-internal-missing-underscore) The name "OnType" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type OnType = typeof eventEmitter.on;

// Warning: (ae-internal-missing-underscore) The name "SubscribeType" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type SubscribeType = (subscriptionType: StateChannelsNotification['method'], params?: any) => Promise<string>;

// Warning: (ae-internal-missing-underscore) The name "UnsubscribeType" should be prefixed with an underscore because the declaration is marked as @internal
//
// @internal (undocumented)
export type UnsubscribeType = (subscriptionId: string) => Promise<boolean>;

// @beta (undocumented)
export type WalletJsonRpcAPI = {
    CreateChannel: {
        request: CreateChannelRequest;
        response: CreateChannelResponse;
    };
    UpdateChannel: {
        request: UpdateChannelRequest;
        response: UpdateChannelResponse;
    };
    PushMessage: {
        request: PushMessageRequest;
        response: PushMessageResponse;
    };
    CloseChannel: {
        request: CloseChannelRequest;
        response: CloseChannelResponse;
    };
    JoinChannel: {
        request: JoinChannelRequest;
        response: JoinChannelResponse;
    };
    GetState: {
        request: GetStateRequest;
        response: GetStateResponse;
    };
    GetWalletInformation: {
        request: GetWalletInformationRequest;
        response: GetWalletInformationResponse;
    };
    EnableEthereum: {
        request: EnableEthereumRequest;
        response: EnableEthereumResponse;
    };
    ChallengeChannel: {
        request: ChallengeChannelRequest;
        response: ChallengeChannelResponse;
    };
    ApproveBudgetAndFund: {
        request: ApproveBudgetAndFundRequest;
        response: ApproveBudgetAndFundResponse;
    };
    GetBudget: {
        request: GetBudgetRequest;
        response: GetBudgetResponse;
    };
    CloseAndWithdraw: {
        request: CloseAndWithdrawRequest;
        response: CloseAndWithdrawResponse;
    };
    GetChannels: {
        request: GetChannelsRequest;
        response: GetChannelsResponse;
    };
};

// @beta
export interface Web3ChannelProviderInterface extends ChannelProviderInterface {
    enable(): Promise<void>;
}


```
