import { Outcome } from './outcome';
export interface ConsensusData {
    furtherVotesRequired: number;
    proposedOutcome: Outcome;
}
export declare function encodeConsensusData(consensusData: ConsensusData): string;
export declare function decodeConsensusData(appData: string): ConsensusData;
export declare function propose(proposedOutcome: Outcome, currentOutcome: Outcome, numberOfParticipants: number): ConsensusDataWithOutcome;
export declare function veto(currentOutcome: Outcome, numberOfParticipants: number): ConsensusDataWithOutcome;
export interface ConsensusDataWithOutcome {
    consensusData: ConsensusData;
    currentOutcome: Outcome;
}
export declare function vote(incomingConsensusData: ConsensusData, numberOfParticipants: number, currentOutcome: Outcome): ConsensusDataWithOutcome;
export declare const voting: {
    propose: typeof propose;
    vote: typeof vote;
    veto: typeof veto;
};
//# sourceMappingURL=consensus-data.d.ts.map