"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var ethers_1 = require("ethers");
var outcome_1 = require("./outcome");
function encodeConsensusData(consensusData) {
    var proposedOutcome = outcome_1.encodeOutcome(consensusData.proposedOutcome);
    return ethers_1.utils.defaultAbiCoder.encode(['tuple(uint32 furtherVotesRequired, bytes proposedOutcome)'], [[consensusData.furtherVotesRequired, proposedOutcome]]);
}
exports.encodeConsensusData = encodeConsensusData;
function decodeConsensusData(appData) {
    var _a = ethers_1.utils.defaultAbiCoder.decode(['tuple(uint32 furtherVotesRequired, bytes proposedOutcome)'], appData)[0], furtherVotesRequired = _a.furtherVotesRequired, proposedOutcome = _a.proposedOutcome;
    return { furtherVotesRequired: furtherVotesRequired, proposedOutcome: outcome_1.decodeOutcome(proposedOutcome) };
}
exports.decodeConsensusData = decodeConsensusData;
function propose(proposedOutcome, currentOutcome, numberOfParticipants) {
    return {
        consensusData: {
            proposedOutcome: proposedOutcome,
            furtherVotesRequired: numberOfParticipants - 1,
        },
        currentOutcome: currentOutcome,
    };
}
exports.propose = propose;
function veto(currentOutcome, numberOfParticipants) {
    return propose([], currentOutcome, numberOfParticipants);
}
exports.veto = veto;
function vote(incomingConsensusData, numberOfParticipants, currentOutcome) {
    if (incomingConsensusData.furtherVotesRequired === 1) {
        return {
            consensusData: { furtherVotesRequired: numberOfParticipants - 1, proposedOutcome: [] },
            currentOutcome: incomingConsensusData.proposedOutcome,
        };
    }
    else if (incomingConsensusData.furtherVotesRequired > 1) {
        return {
            consensusData: {
                furtherVotesRequired: incomingConsensusData.furtherVotesRequired - 1,
                proposedOutcome: incomingConsensusData.proposedOutcome,
            },
            currentOutcome: currentOutcome,
        };
    }
    else {
        throw new Error("Expected furtherVotesRequired to be greater than 0, received " + incomingConsensusData.furtherVotesRequired + " instead");
    }
}
exports.vote = vote;
exports.voting = {
    propose: propose,
    vote: vote,
    veto: veto,
};
//# sourceMappingURL=consensus-data.js.map