"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var ethers_1 = require("ethers");
var ConsensusApp_json_1 = __importDefault(require("../../../build/contracts/ConsensusApp.json"));
var consensus_app_1 = require("../consensus-app");
var ConsensusAppContractInterface = new ethers_1.ethers.utils.Interface(ConsensusApp_json_1.default.abi);
function createValidTransitionTransaction(fromConsensusData, fromOutcome, toConsensusData, toOutcome, numberOfParticipants) {
    var fromVariablePart = consensus_app_1.getVariablePart(fromConsensusData, fromOutcome);
    var toVariablePart = consensus_app_1.getVariablePart(toConsensusData, toOutcome);
    var turnNumB = 0;
    var data = ConsensusAppContractInterface.encodeFunctionData('validTransition', [
        fromVariablePart,
        toVariablePart,
        turnNumB,
        numberOfParticipants,
    ]);
    return { data: data };
}
exports.createValidTransitionTransaction = createValidTransitionTransaction;
//# sourceMappingURL=consensus-app.js.map