"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var devtools_1 = require("@statechannels/devtools");
var ethers_1 = require("ethers");
var ConsensusApp_json_1 = __importDefault(require("../../../build/contracts/ConsensusApp.json"));
var consensus_app_1 = require("../../../src/contract/consensus-app");
var consensus_app_2 = require("../../../src/contract/transaction-creators/consensus-app");
var test_helpers_1 = require("../../test-helpers");
var provider = test_helpers_1.getTestProvider();
var consensusApp;
var numParticipants = 3;
beforeAll(function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4, test_helpers_1.setupContracts(provider, ConsensusApp_json_1.default, process.env.CONSENSUS_APP_ADDRESS)];
            case 1:
                consensusApp = _a.sent();
                return [2];
        }
    });
}); });
describe('validTransition', function () {
    it.each(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n    isValid  | votesReqd | outcomes            | proposedOutcomes    | description\n    ", "  | ", " | ", " | ", " | ", "\n    ", " | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", " | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", " | ", " | ", " | ", " | ", "\n  "], ["\n    isValid  | votesReqd | outcomes            | proposedOutcomes    | description\n    ", "  | ", " | ", " | ", " | ", "\n    ", " | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", " | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", "  | ", " | ", " | ", " | ", "\n    ", " | ", " | ", " | ", " | ", "\n  "])), true, [0, 2], ['0x01', '0x01'], ['0x01', '0x02'], 'valid consensus -> propose', false, [0, 1], ['0x01', '0x01'], ['0x01', '0x02'], 'invalid consensus -> propose: votesReqd too low', true, [2, 1], ['0x01', '0x01'], ['0x02', '0x02'], 'valid vote', false, [1, 1], ['0x01', '0x01'], ['0x02', '0x02'], 'invalid vote: votesReqd not decreased', true, [1, 2], ['0x01', '0x01'], ['0x02', '0x01'], 'valid veto', true, [2, 2], ['0x01', '0x01'], ['0x02', '0x02'], 'valid pass', true, [1, 0], ['0x01', '0x02'], ['0x02', '0x00'], 'valid finalVote', false, [1, 0], ['0x01', '0x03'], ['0x02', '0x00'], 'invalid finalVote: proposedOutcome1 ≠ currentOutcome2')('$description', function (_a) {
        var isValid = _a.isValid, outcomes = _a.outcomes, proposedOutcomes = _a.proposedOutcomes, votesReqd = _a.votesReqd;
        return __awaiter(void 0, void 0, void 0, function () {
            var fromConsensusData, fromOutcome, toConsensusData, toOutcome, transactionRequest, isValidFromCall;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        fromConsensusData = {
                            furtherVotesRequired: votesReqd[0],
                            proposedOutcome: createOutcome(proposedOutcomes[0]),
                        };
                        fromOutcome = createOutcome(outcomes[0]);
                        toConsensusData = {
                            furtherVotesRequired: votesReqd[1],
                            proposedOutcome: createOutcome(proposedOutcomes[1]),
                        };
                        toOutcome = createOutcome(outcomes[1]);
                        transactionRequest = consensus_app_2.createValidTransitionTransaction(fromConsensusData, fromOutcome, toConsensusData, toOutcome, numParticipants);
                        if (!isValid) return [3, 3];
                        return [4, sendTransaction(consensusApp.address, transactionRequest)];
                    case 1:
                        _b.sent();
                        return [4, consensus_app_1.validTransition(fromConsensusData, fromOutcome, toConsensusData, toOutcome, numParticipants, consensusApp.signer, consensusApp.address)];
                    case 2:
                        isValidFromCall = _b.sent();
                        expect(isValidFromCall).toBe(true);
                        return [3, 5];
                    case 3: return [4, devtools_1.expectRevert(function () { return sendTransaction(consensusApp.address, transactionRequest); })];
                    case 4:
                        _b.sent();
                        _b.label = 5;
                    case 5: return [2];
                }
            });
        });
    });
});
function sendTransaction(contractAddress, transaction) {
    return __awaiter(this, void 0, void 0, function () {
        var signer, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    signer = provider.getSigner();
                    return [4, signer.sendTransaction(__assign({ to: contractAddress }, transaction))];
                case 1:
                    response = _a.sent();
                    return [4, response.wait()];
                case 2:
                    _a.sent();
                    return [2];
            }
        });
    });
}
function createOutcome(amount) {
    return [
        {
            assetHolderAddress: ethers_1.ethers.constants.AddressZero,
            allocationItems: [{ destination: ethers_1.ethers.constants.HashZero, amount: amount }],
        },
    ];
}
var templateObject_1;
//# sourceMappingURL=validTransition.test.js.map