"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var ethers_1 = require("ethers");
var TrivialApp_json_1 = __importDefault(require("../../../build/contracts/TrivialApp.json"));
var force_move_app_1 = require("../../../src/contract/force-move-app");
var test_helpers_1 = require("../../test-helpers");
var provider = test_helpers_1.getTestProvider();
var trivialApp;
function computeSaltedHash(salt, num) {
    return ethers_1.utils.solidityKeccak256(['bytes32', 'uint256'], [salt, num]);
}
function getRandomVariablePart() {
    var randomNum = Math.floor(Math.random() * 100);
    var salt = ethers_1.ethers.constants.MaxUint256.toHexString();
    var hash = computeSaltedHash(salt, randomNum);
    var variablePart = {
        outcome: hash,
        appData: hash,
    };
    return variablePart;
}
beforeAll(function () { return __awaiter(void 0, void 0, void 0, function () {
    return __generator(this, function (_a) {
        switch (_a.label) {
            case 0: return [4, test_helpers_1.setupContracts(provider, TrivialApp_json_1.default, process.env.TRIVIAL_APP_ADDRESS)];
            case 1:
                trivialApp = _a.sent();
                return [2];
        }
    });
}); });
describe('validTransition', function () {
    it('Transitions between random VariableParts are valid', function () { return __awaiter(void 0, void 0, void 0, function () {
        var i, from, to, isValidFromCall;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    expect.assertions(5);
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < 5)) return [3, 4];
                    from = getRandomVariablePart();
                    to = getRandomVariablePart();
                    return [4, trivialApp.validTransition(from, to, 0, 0)];
                case 2:
                    isValidFromCall = _a.sent();
                    expect(isValidFromCall).toBe(true);
                    _a.label = 3;
                case 3:
                    i++;
                    return [3, 1];
                case 4: return [2];
            }
        });
    }); });
    it('Transitions between States with mocked-up data are valid', function () { return __awaiter(void 0, void 0, void 0, function () {
        var channel, fromState, toState, _a;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    channel = {
                        participants: [ethers_1.Wallet.createRandom().address, ethers_1.Wallet.createRandom().address],
                        chainId: '0x1',
                        channelNonce: 0x01,
                    };
                    fromState = {
                        channel: channel,
                        outcome: [],
                        turnNum: 1,
                        isFinal: false,
                        challengeDuration: 0x0,
                        appDefinition: trivialApp.address,
                        appData: '0x00',
                    };
                    toState = __assign(__assign({}, fromState), { turnNum: 2 });
                    _a = expect;
                    return [4, force_move_app_1.validTransition(fromState, toState, trivialApp)];
                case 1:
                    _a.apply(void 0, [_b.sent()]).toBe(true);
                    return [2];
            }
        });
    }); });
});
//# sourceMappingURL=validTransition.test.js.map