"use strict";
var __makeTemplateObject = (this && this.__makeTemplateObject) || function (cooked, raw) {
    if (Object.defineProperty) { Object.defineProperty(cooked, "raw", { value: raw }); } else { cooked.raw = raw; }
    return cooked;
};
Object.defineProperty(exports, "__esModule", { value: true });
var ethers_1 = require("ethers");
var consensus_data_1 = require("../../../src/contract/consensus-data");
describe('consensus-data', function () {
    describe('voting', function () {
        var assetHolderAddress = ethers_1.Wallet.createRandom().address;
        var numberOfParticipants = 3;
        var destinations = [ethers_1.utils.id('a'), ethers_1.utils.id('b'), ethers_1.utils.id('c')];
        var proposedOutcome = [
            {
                assetHolderAddress: assetHolderAddress,
                allocationItems: destinations.map(function (d, i) { return ({ amount: '0x1', destination: d }); }),
            },
        ];
        var currentOutcome = [
            {
                assetHolderAddress: assetHolderAddress,
                allocationItems: destinations.map(function (d, i) { return ({ amount: '0x00', destination: d }); }),
            },
        ];
        var description0 = 'propose works';
        var description1 = 'first vote works';
        var description2 = 'final vote works';
        var description3 = 'veto works';
        it.each(templateObject_1 || (templateObject_1 = __makeTemplateObject(["\n      description     | fromArgs                                                                              | voteFunction | expectedConsensusData                                                | expectedCurrentOutcome\n      ", " | ", "                            | ", "   | ", " | ", "\n      ", " | ", " | ", "      | ", "                        | ", "\n      ", " | ", " | ", "      | ", "                    | ", "\n      ", " | ", "                                             | ", "      | ", "                    | ", "\n    "], ["\n      description     | fromArgs                                                                              | voteFunction | expectedConsensusData                                                | expectedCurrentOutcome\n      ", " | ", "                            | ", "   | ", " | ", "\n      ", " | ", " | ", "      | ", "                        | ", "\n      ", " | ", " | ", "      | ", "                    | ", "\n      ", " | ", "                                             | ", "      | ", "                    | ", "\n    "])), description0, [proposedOutcome, currentOutcome, numberOfParticipants], consensus_data_1.propose, { proposedOutcome: proposedOutcome, furtherVotesRequired: numberOfParticipants - 1 }, currentOutcome, description1, [{ proposedOutcome: proposedOutcome, furtherVotesRequired: 2 }, numberOfParticipants, currentOutcome], consensus_data_1.vote, { proposedOutcome: proposedOutcome, furtherVotesRequired: 1 }, currentOutcome, description2, [{ proposedOutcome: proposedOutcome, furtherVotesRequired: 1 }, numberOfParticipants, currentOutcome], consensus_data_1.vote, { proposedOutcome: [], furtherVotesRequired: 2 }, proposedOutcome, description3, [currentOutcome, numberOfParticipants], consensus_data_1.veto, { proposedOutcome: [], furtherVotesRequired: 2 }, currentOutcome)('$description', function (_a) {
            var fromArgs = _a.fromArgs, voteFunction = _a.voteFunction, expectedConsensusData = _a.expectedConsensusData, expectedCurrentOutcome = _a.expectedCurrentOutcome;
            var voteResults = voteFunction.apply(void 0, fromArgs);
            expect(voteResults.consensusData).toEqual(expectedConsensusData);
            expect(voteResults.currentOutcome).toEqual(expectedCurrentOutcome);
        });
    });
    describe('encoding and decoding', function () {
        var consensusData = {
            furtherVotesRequired: 5,
            proposedOutcome: [{ assetHolderAddress: ethers_1.constants.AddressZero, allocationItems: [] }],
        };
        var emptyConsensusData = { furtherVotesRequired: 0, proposedOutcome: [] };
        var description0 = 'encodes and decodes a Consensus Data';
        var description1 = 'encodes and decodes an empty Consensus Data';
        it.each(templateObject_2 || (templateObject_2 = __makeTemplateObject(["\n      description     | data\n      ", " | ", "\n      ", " | ", "\n    "], ["\n      description     | data\n      ", " | ", "\n      ", " | ", "\n    "])), description0, consensusData, description1, emptyConsensusData)('$description', function (_a) {
            var data = _a.data;
            var encodedData = consensus_data_1.encodeConsensusData(data);
            var decodedData = consensus_data_1.decodeConsensusData(encodedData);
            expect(decodedData).toEqual(data);
        });
    });
});
var templateObject_1, templateObject_2;
//# sourceMappingURL=consensus-data.test.js.map