"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:allocate:memory");
const CodecUtils = __importStar(require("../utils"));
function getMemoryAllocations(referenceDeclarations) {
    let allocations = {};
    for (const node of Object.values(referenceDeclarations)) {
        if (node.nodeType === "StructDefinition") {
            allocations[node.id] = allocateStruct(node);
        }
    }
    return allocations;
}
exports.getMemoryAllocations = getMemoryAllocations;
//unlike in storage and calldata, we'll just return the one allocation, nothing fancy
//that's because allocating one struct can never necessitate allocating another
function allocateStruct(definition) {
    let memberAllocations = [];
    let position = 0;
    for (const member of definition.members) {
        const length = CodecUtils.Definition.isMapping(member)
            ? 0
            : CodecUtils.EVM.WORD_SIZE;
        memberAllocations.push({
            definition: member,
            pointer: {
                location: "memory",
                start: position,
                length
            }
        });
        position += length;
    }
    return {
        definition,
        members: memberAllocations
    };
}
//# sourceMappingURL=memory.js.map