"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:core:abify");
const format_1 = require("../format");
/* the following functions are not used anywhere in our code at present.
 * they are intended for external use -- the idea is that if you don't
 * like having to deal with the possibility of having the decoder return
 * either a full-mode or an abi-mode decoding, well, you can always
 * abify to ensure you get an abi-mode decoding.
 * (if you want to ensure you get a full-mode decoding... well, you can't,
 * but you can, uh, throw an exception if you don't, I guess.)
 */
function abifyCalldataDecoding(decoding, userDefinedTypes) {
    if (decoding.decodingMode === "abi") {
        return decoding;
    }
    switch (decoding.kind) {
        case "function":
        case "constructor":
            return Object.assign(Object.assign({}, decoding), { decodingMode: "abi", arguments: decoding.arguments.map(({ name, value }) => ({ name, value: format_1.abifyResult(value, userDefinedTypes) })) });
        default:
            return Object.assign(Object.assign({}, decoding), { decodingMode: "abi" });
    }
}
exports.abifyCalldataDecoding = abifyCalldataDecoding;
function abifyLogDecoding(decoding, userDefinedTypes) {
    if (decoding.decodingMode === "abi") {
        return decoding;
    }
    return Object.assign(Object.assign({}, decoding), { decodingMode: "abi", arguments: decoding.arguments.map(({ name, value }) => ({ name, value: format_1.abifyResult(value, userDefinedTypes) })) });
}
exports.abifyLogDecoding = abifyLogDecoding;
//# sourceMappingURL=abify.js.map