"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:decode:event");
const value_1 = __importDefault(require("./value"));
const read_1 = __importDefault(require("../read"));
const utils_1 = require("../utils");
function* decodeTopic(dataType, pointer, info, options = {}) {
    if (utils_1.TypeUtils.isReferenceType(dataType)) {
        //we cannot decode reference types "stored" in topics; we have to just return an error
        let bytes = yield* read_1.default(pointer, info.state);
        let raw = utils_1.Conversion.toHexString(bytes);
        //NOTE: even in strict mode we want to just return this, not throw an error here
        return {
            type: dataType,
            kind: "error",
            error: {
                kind: "IndexedReferenceTypeError",
                type: dataType,
                raw
            }
        };
    }
    //otherwise, dispatch to decodeValue
    return yield* value_1.default(dataType, pointer, info, options);
}
exports.default = decodeTopic;
//# sourceMappingURL=event.js.map