"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:decode");
const memory_1 = __importDefault(require("./memory"));
const storage_1 = __importDefault(require("./storage"));
const stack_1 = __importDefault(require("./stack"));
const stack_2 = require("./stack");
const abi_1 = __importDefault(require("./abi"));
const constant_1 = __importDefault(require("./constant"));
const special_1 = __importDefault(require("./special"));
const event_1 = __importDefault(require("./event"));
function* decode(dataType, pointer, info, options = {}) {
    debug("type %O", dataType);
    debug("pointer %O", pointer);
    switch (pointer.location) {
        case "storage":
            return yield* storage_1.default(dataType, pointer, info);
        case "stack":
            return yield* stack_1.default(dataType, pointer, info);
        case "stackliteral":
            return yield* stack_2.decodeLiteral(dataType, pointer, info);
        case "definition":
            return yield* constant_1.default(dataType, pointer, info);
        case "special":
            return yield* special_1.default(dataType, pointer, info);
        case "calldata":
        case "eventdata":
            return yield* abi_1.default(dataType, pointer, info, options);
        case "eventtopic":
            return yield* event_1.default(dataType, pointer, info, options);
        case "memory":
            //NOTE: this case should never actually occur, but I'm including it
            //anyway as a fallback
            return yield* memory_1.default(dataType, pointer, info);
    }
}
exports.default = decode;
//# sourceMappingURL=index.js.map