"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:decode:memory");
const read_1 = __importDefault(require("../read"));
const CodecUtils = __importStar(require("../utils"));
const utils_1 = require("../utils");
const value_1 = __importDefault(require("./value"));
function* decodeMemory(dataType, pointer, info) {
    if (utils_1.TypeUtils.isReferenceType(dataType)) {
        return yield* decodeMemoryReferenceByAddress(dataType, pointer, info);
    }
    else {
        return yield* value_1.default(dataType, pointer, info);
    }
}
exports.default = decodeMemory;
function* decodeMemoryReferenceByAddress(dataType, pointer, info) {
    const { state } = info;
    // debug("pointer %o", pointer);
    let rawValue;
    try {
        rawValue = yield* read_1.default(pointer, state);
    }
    catch (error) {
        return {
            type: dataType,
            kind: "error",
            error: error.error
        };
    }
    let startPositionAsBN = CodecUtils.Conversion.toBN(rawValue);
    let startPosition;
    try {
        startPosition = startPositionAsBN.toNumber();
    }
    catch (_) {
        return {
            type: dataType,
            kind: "error",
            error: {
                kind: "OverlargePointersNotImplementedError",
                pointerAsBN: startPositionAsBN
            }
        };
    }
    let rawLength;
    let lengthAsBN;
    let length;
    switch (dataType.typeClass) {
        case "bytes":
        case "string":
            //initial word contains length
            try {
                rawLength = yield* read_1.default({
                    location: "memory",
                    start: startPosition,
                    length: CodecUtils.EVM.WORD_SIZE
                }, state);
            }
            catch (error) {
                return {
                    type: dataType,
                    kind: "error",
                    error: error.error
                };
            }
            lengthAsBN = CodecUtils.Conversion.toBN(rawLength);
            try {
                length = lengthAsBN.toNumber();
            }
            catch (_) {
                return {
                    type: dataType,
                    kind: "error",
                    error: {
                        kind: "OverlongArraysAndStringsNotImplementedError",
                        lengthAsBN
                    }
                };
            }
            let childPointer = {
                location: "memory",
                start: startPosition + CodecUtils.EVM.WORD_SIZE,
                length
            };
            return yield* value_1.default(dataType, childPointer, info);
        case "array":
            if (dataType.kind === "dynamic") {
                //initial word contains array length
                try {
                    rawLength = yield* read_1.default({
                        location: "memory",
                        start: startPosition,
                        length: CodecUtils.EVM.WORD_SIZE
                    }, state);
                }
                catch (error) {
                    return {
                        type: dataType,
                        kind: "error",
                        error: error.error
                    };
                }
                lengthAsBN = CodecUtils.Conversion.toBN(rawLength);
                startPosition += CodecUtils.EVM.WORD_SIZE; //increment startPosition
                //to next word, as first word was used for length
            }
            else {
                lengthAsBN = dataType.length;
            }
            try {
                length = lengthAsBN.toNumber();
            }
            catch (_) {
                return {
                    type: dataType,
                    kind: "error",
                    error: {
                        kind: "OverlongArraysAndStringsNotImplementedError",
                        lengthAsBN
                    }
                };
            }
            let baseType = dataType.baseType;
            let decodedChildren = [];
            for (let index = 0; index < length; index++) {
                decodedChildren.push(yield* decodeMemory(baseType, {
                    location: "memory",
                    start: startPosition + index * CodecUtils.EVM.WORD_SIZE,
                    length: CodecUtils.EVM.WORD_SIZE
                }, info));
            }
            return {
                type: dataType,
                kind: "value",
                value: decodedChildren
            };
        case "struct":
            const { allocations: { memory: allocations }, userDefinedTypes } = info;
            const typeId = dataType.id;
            const structAllocation = allocations[parseInt(typeId)];
            if (!structAllocation) {
                return {
                    type: dataType,
                    kind: "error",
                    error: {
                        kind: "UserDefinedTypeNotFoundError",
                        type: dataType
                    }
                };
            }
            debug("structAllocation %O", structAllocation);
            let decodedMembers = [];
            for (let index = 0; index < structAllocation.members.length; index++) {
                const memberAllocation = structAllocation.members[index];
                const memberPointer = memberAllocation.pointer;
                const childPointer = {
                    location: "memory",
                    start: startPosition + memberPointer.start,
                    length: memberPointer.length //always equals WORD_SIZE or 0
                };
                let memberName = memberAllocation.definition.name;
                let storedType = userDefinedTypes[typeId];
                if (!storedType) {
                    return {
                        type: dataType,
                        kind: "error",
                        error: {
                            kind: "UserDefinedTypeNotFoundError",
                            type: dataType
                        }
                    };
                }
                let storedMemberType = storedType.memberTypes[index].type;
                let memberType = utils_1.TypeUtils.specifyLocation(storedMemberType, "memory");
                decodedMembers.push({
                    name: memberName,
                    value: yield* decodeMemory(memberType, childPointer, info)
                });
            }
            return {
                type: dataType,
                kind: "value",
                value: decodedMembers
            };
        case "mapping":
            //a mapping in memory is always empty
            return {
                type: dataType,
                kind: "value",
                value: []
            };
    }
}
exports.decodeMemoryReferenceByAddress = decodeMemoryReferenceByAddress;
//# sourceMappingURL=memory.js.map