"use strict";
//So, what shall codec export...?
function __export(m) {
    for (var p in m) if (!exports.hasOwnProperty(p)) exports[p] = m[p];
}
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
//First: export the data format
__export(require("./format"));
//next: export all the utils!
//you can't do "export * as Name" for whatever reason so...
const Utils = __importStar(require("./utils"));
exports.Utils = Utils;
//next: export the interface, duh
__export(require("./interface"));
//now... various low-level stuff we want to export!
//the actual decoding functions
var decoding_1 = require("./core/decoding");
exports.decodeVariable = decoding_1.decodeVariable;
exports.decodeEvent = decoding_1.decodeEvent;
exports.decodeCalldata = decoding_1.decodeCalldata;
//the debugger needs to get its allocations, and deal with storage sizes
var storage_1 = require("./allocate/storage");
exports.getStorageAllocations = storage_1.getStorageAllocations;
exports.storageSize = storage_1.storageSize;
var abi_1 = require("./allocate/abi");
exports.getAbiAllocations = abi_1.getAbiAllocations;
var memory_1 = require("./allocate/memory");
exports.getMemoryAllocations = memory_1.getMemoryAllocations;
//and to read the stack
var stack_1 = require("./read/stack");
exports.readStack = stack_1.readStack;
//finally, let's export the low-level encoding functions, because why not, someone
//might want them :P
var abi_2 = require("./encode/abi");
exports.encodeAbi = abi_2.encodeAbi;
exports.encodeTupleAbi = abi_2.encodeTupleAbi;
var key_1 = require("./encode/key");
exports.encodeMappingKey = key_1.encodeMappingKey;
__export(require("./types/errors")); //the various errors we might throw
//and for those who want *all* the types...
const InternalTypes = __importStar(require("./types"));
exports.InternalTypes = InternalTypes;
//# sourceMappingURL=index.js.map