"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:interface");
const contract_1 = __importDefault(require("./contract"));
exports.TruffleContractDecoder = contract_1.default;
const contract_2 = require("./contract");
exports.TruffleContractInstanceDecoder = contract_2.TruffleContractInstanceDecoder;
const wire_1 = __importDefault(require("./wire"));
exports.TruffleWireDecoder = wire_1.default;
function forContractInstance(contract, relevantContracts, provider, address) {
    return __awaiter(this, void 0, void 0, function* () {
        let contractDecoder = yield forContract(contract, relevantContracts, provider);
        let instanceDecoder = yield contractDecoder.forInstance(address);
        return instanceDecoder;
    });
}
exports.forContractInstance = forContractInstance;
function forContract(contract, relevantContracts, provider) {
    return __awaiter(this, void 0, void 0, function* () {
        let contracts = relevantContracts.includes(contract)
            ? relevantContracts
            : [contract, ...relevantContracts];
        let wireDecoder = yield forProject(contracts, provider);
        let contractDecoder = new contract_1.default(contract, wireDecoder);
        yield contractDecoder.init();
        return contractDecoder;
    });
}
exports.forContract = forContract;
function forProject(contracts, provider) {
    return __awaiter(this, void 0, void 0, function* () {
        return new wire_1.default(contracts, provider);
    });
}
exports.forProject = forProject;
function forContractWithDecoder(contract, decoder) {
    return __awaiter(this, void 0, void 0, function* () {
        let contractDecoder = new contract_1.default(contract, decoder);
        yield contractDecoder.init();
        return contractDecoder;
    });
}
exports.forContractWithDecoder = forContractWithDecoder;
//# sourceMappingURL=index.js.map