import * as Common from "../common";
export declare type Abi = AbiEntry[];
export declare type AbiEntry = FunctionAbiEntry | ConstructorAbiEntry | FallbackAbiEntry | EventAbiEntry;
export interface FunctionAbiEntry {
    type: "function";
    name: string;
    inputs: AbiParameter[];
    outputs: AbiParameter[];
    stateMutability?: Common.Mutability;
    constant?: boolean;
    payable?: boolean;
}
export interface ConstructorAbiEntry {
    type: "constructor";
    inputs: AbiParameter[];
    stateMutability?: "payable" | "nonpayable";
    payable?: boolean;
}
export interface FallbackAbiEntry {
    type: "fallback";
    stateMutability?: "payable" | "nonpayable";
    payable?: boolean;
}
export interface EventAbiEntry {
    type: "event";
    name: string;
    inputs: AbiParameter[];
    anonymous: boolean;
}
export interface AbiParameter {
    name: string;
    type: string;
    indexed?: boolean;
    components?: AbiParameter[];
    internalType?: string;
}
export interface FunctionAbiBySelectors {
    [selector: string]: FunctionAbiEntry;
}
