import * as Storage from "../storage/types";
import * as Ast from "../ast";
import * as Allocation from "./types";
import * as Format from "../format";
export declare class UnknownBaseContractIdError extends Error {
    derivedId: number;
    derivedName: string;
    derivedKind: string;
    baseId: number;
    constructor(derivedId: number, derivedName: string, derivedKind: string, baseId: number);
}
export declare function getStorageAllocations(referenceDeclarations: Ast.AstNodes, contracts: Ast.AstNodes, existingAllocations?: Allocation.StorageAllocations): Allocation.StorageAllocations;
export declare function storageSize(definition: Ast.AstNode, referenceDeclarations?: Ast.AstNodes, allocations?: Allocation.StorageAllocations): Storage.StorageLength;
export declare function storageSizeForType(dataType: Format.Types.Type, userDefinedTypes?: Format.Types.TypesById, allocations?: Allocation.StorageAllocations): Storage.StorageLength;
