import * as Compiler from "../compiler";
import * as Storage from "../storage/types";
import * as Ast from "../ast";
import * as Abi from "../abi/types";
import * as Contexts from "../contexts/types";
import * as Pointer from "../pointer";
import { DecodingMode } from "../types";
import * as Format from "../format";
export interface ContractAllocationInfo {
    abi: Abi.Abi;
    contractNode: Ast.AstNode;
    deployedContext?: Contexts.DecoderContext;
    constructorContext?: Contexts.DecoderContext;
    compiler: Compiler.CompilerVersion;
}
export interface AbiSizeInfo {
    size: number;
    dynamic: boolean;
}
export interface StorageAllocations {
    [id: number]: StorageAllocation;
}
export interface StorageAllocation {
    definition: Ast.AstNode;
    size?: Storage.StorageLength;
    members: StorageMemberAllocation[];
}
export interface StorageMemberAllocation {
    definition: Ast.AstNode;
    definedIn?: Ast.AstNode;
    pointer: Pointer.StoragePointer | Pointer.ConstantDefinitionPointer;
}
export interface AbiAllocations {
    [id: string]: AbiAllocation | null;
}
export interface AbiAllocation {
    length: number;
    dynamic: boolean;
    members: AbiMemberAllocation[];
}
export interface AbiMemberAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.GenericAbiPointer;
}
export interface MemoryAllocations {
    [id: number]: MemoryAllocation;
}
export interface MemoryAllocation {
    definition: Ast.AstNode;
    members: MemoryMemberAllocation[];
}
export interface MemoryMemberAllocation {
    definition: Ast.AstNode;
    pointer: Pointer.MemoryPointer;
}
export interface CalldataAllocations {
    constructorAllocations: CalldataConstructorAllocations;
    functionAllocations: CalldataFunctionAllocations;
}
export interface CalldataConstructorAllocations {
    [contextHash: string]: CalldataAllocation;
}
export interface CalldataFunctionAllocations {
    [contextHash: string]: {
        [selector: string]: CalldataAllocation;
    };
}
export interface CalldataAllocation {
    abi: Abi.FunctionAbiEntry | Abi.ConstructorAbiEntry;
    offset: number;
    arguments: CalldataArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface CalldataArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.CalldataPointer;
}
export interface EventAllocations {
    [topics: number]: {
        bySelector: {
            [selector: string]: {
                [contractKind: string]: {
                    [contextHash: string]: EventAllocation;
                };
            };
        };
        anonymous: {
            [contractKind: string]: {
                [contextHash: string]: EventAllocation[];
            };
        };
    };
}
export interface EventAllocation {
    abi: Abi.EventAbiEntry;
    contextHash: string;
    anonymous: boolean;
    arguments: EventArgumentAllocation[];
    allocationMode: DecodingMode;
}
export interface EventArgumentAllocation {
    name: string;
    type: Format.Types.Type;
    pointer: Pointer.EventDataPointer | Pointer.EventTopicPointer;
}
export interface EventAllocationTemporary {
    selector?: string;
    topics: number;
    allocation: EventAllocation;
}
export interface CalldataAllocationTemporary {
    constructorAllocation?: CalldataAllocation;
    functionAllocations: {
        [selector: string]: CalldataAllocation;
    };
}
