"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:decode:constant");
const Conversion = __importStar(require("../conversion"));
const read_1 = __importDefault(require("../read"));
const value_1 = __importDefault(require("./value"));
const Evm = __importStar(require("../evm"));
function* decodeConstant(dataType, pointer, info) {
    debug("pointer %o", pointer);
    //normally, we just dispatch to decodeValue.
    //for statically-sized bytes, however, we need to make a special case.
    //you see, decodeValue expects to find the bytes at the *beginning*
    //of the word, but readDefinition will put them at the *end* of the
    //word.  So we'll have to adjust things ourselves.
    if (dataType.typeClass === "bytes" && dataType.kind === "static") {
        let size = dataType.length;
        let word;
        try {
            word = yield* read_1.default(pointer, info.state);
        }
        catch (error) {
            return {
                type: dataType,
                kind: "error",
                error: error.error
            };
        }
        //not bothering to check padding; shouldn't be necessary
        let bytes = word.slice(Evm.Utils.WORD_SIZE - size);
        return {
            type: dataType,
            kind: "value",
            value: {
                asHex: Conversion.toHexString(bytes)
            }
        }; //we'll skip including a raw value, as that would be meaningless
    }
    //otherwise, as mentioned, just dispatch to decodeValue
    debug("not a static bytes");
    return yield* value_1.default(dataType, pointer, info);
}
exports.default = decodeConstant;
//# sourceMappingURL=constant.js.map