"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:encode:key");
const Conversion = __importStar(require("../conversion"));
const Evm = __importStar(require("../evm"));
const abi_1 = require("./abi");
//UGH -- it turns out TypeScript can't handle nested tagged unions
//see: https://github.com/microsoft/TypeScript/issues/18758
//so, I'm just going to have to throw in a bunch of type coercions >_>
/**
 * @Category Encoding (low-level)
 */
function encodeMappingKey(input) {
    let bytes;
    //TypeScript can at least infer in the rest of this that we're looking
    //at a value, not an error!  But that's hardly enough...
    switch (input.type.typeClass) {
        case "uint":
        case "int":
            return Conversion.toBytes(input.value.asBN, Evm.Utils.WORD_SIZE);
        case "bool": {
            bytes = new Uint8Array(Evm.Utils.WORD_SIZE); //is initialized to zeroes
            if (input.value.asBoolean) {
                bytes[Evm.Utils.WORD_SIZE - 1] = 1;
            }
            return bytes;
        }
        case "bytes":
            bytes = Conversion.toBytes(input.value.asHex);
            switch (input.type.kind) {
                case "static":
                    let padded = new Uint8Array(Evm.Utils.WORD_SIZE); //initialized to zeroes
                    padded.set(bytes);
                    return padded;
                case "dynamic":
                    return bytes; //NO PADDING IS USED
            }
        case "address":
            return Conversion.toBytes(input.value.asAddress, Evm.Utils.WORD_SIZE);
        case "string": {
            let coercedInput = (input);
            switch (coercedInput.value.kind //NO PADDING IS USED
            ) {
                case "valid":
                    return abi_1.stringToBytes(coercedInput.value.asString);
                case "malformed":
                    return Conversion.toBytes(coercedInput.value.asHex);
            }
            break; //to satisfy TypeScript
        }
        case "fixed":
        case "ufixed":
            let bigValue = (input).value.asBig;
            let shiftedValue = Conversion.shiftBigUp(bigValue, input.type.places);
            return Conversion.toBytes(shiftedValue, Evm.Utils.WORD_SIZE);
    }
}
exports.encodeMappingKey = encodeMappingKey;
function mappingKeyAsHex(input) {
    return Conversion.toHexString(encodeMappingKey(input));
}
exports.mappingKeyAsHex = mappingKeyAsHex;
//# sourceMappingURL=key.js.map