"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:format:utils:serial");
const bn_js_1 = __importDefault(require("bn.js"));
const big_js_1 = __importDefault(require("big.js"));
const circularity_1 = require("./circularity");
//SERIALIZATION
function serializeResult(value) {
    return serializeUntiedResult(circularity_1.sever(value));
}
exports.serializeResult = serializeResult;
function serializeType(dataType) {
    switch (dataType.typeClass) {
        case "array":
            switch (dataType.kind) {
                case "static":
                    return {
                        typeClass: "array",
                        kind: "static",
                        baseType: serializeType(dataType.baseType),
                        location: dataType.location,
                        typeHint: dataType.typeHint,
                        lengthAsString: dataType.length.toString()
                    };
                case "dynamic":
                    return Object.assign(Object.assign({}, dataType), { baseType: serializeType(dataType.baseType) });
            }
            break; //for TS
        case "struct":
            if (dataType.memberTypes !== undefined) {
                return Object.assign(Object.assign({}, dataType), { memberTypes: dataType.memberTypes.map(({ name, type: memberType }) => ({
                        name,
                        type: serializeType(memberType)
                    })) });
            }
            else {
                return dataType; //ugh Typescript
            }
        case "tuple":
            return Object.assign(Object.assign({}, dataType), { memberTypes: dataType.memberTypes.map(({ name, type: memberType }) => ({
                    name,
                    type: serializeType(memberType)
                })) });
        case "mapping":
            return Object.assign(Object.assign({}, dataType), { valueType: serializeType(dataType.valueType), keyType: (serializeType(dataType.keyType)) });
        case "function":
            switch (dataType.visibility) {
                case "internal":
                    return Object.assign(Object.assign({}, dataType), { inputParameterTypes: dataType.inputParameterTypes.map(serializeType), outputParameterTypes: dataType.outputParameterTypes.map(serializeType) });
                case "external":
                    switch (dataType.kind) {
                        case "specific":
                            return Object.assign(Object.assign({}, dataType), { inputParameterTypes: dataType.inputParameterTypes.map(serializeType), outputParameterTypes: dataType.outputParameterTypes.map(serializeType) });
                        case "general":
                            return dataType;
                    }
                    break; //for TS
            }
            break; //for TS
        case "magic":
            if (dataType.memberTypes !== undefined) {
                return Object.assign(Object.assign({}, dataType), { memberTypes: Object.assign({}, ...Object.entries(dataType.memberTypes).map(([name, memberType]) => ({
                        [name]: serializeType(memberType)
                    }))) });
            }
            else {
                return dataType; //ugh
            }
        case "type":
            switch (dataType.type.typeClass) {
                case "contract":
                    let coercedType = dataType;
                    if (coercedType.stateVariableTypes !== undefined) {
                        return Object.assign(Object.assign({}, coercedType), { stateVariableTypes: coercedType.stateVariableTypes.map(({ name, type: stateVariableType }) => ({
                                name,
                                type: serializeType(stateVariableType)
                            })) });
                    }
                    else {
                        return coercedType; //fricking TypeScript
                    }
                case "enum":
                    return dataType;
            }
        default:
            return dataType;
    }
}
exports.serializeType = serializeType;
function serializeUntiedResult(value) {
    let serializedType = serializeType(value.type);
    switch (value.kind) {
        case "value":
            switch (value.type.typeClass) {
                case "uint":
                case "int": {
                    let coercedValue = (value);
                    if (coercedValue.value.rawAsBN) {
                        return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: {
                                asString: coercedValue.value.asBN.toString(),
                                rawAsString: coercedValue.value.rawAsBN.toString()
                            } });
                    }
                    else {
                        return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: {
                                asString: coercedValue.value.asBN.toString()
                            } });
                    }
                }
                case "fixed":
                case "ufixed": {
                    let coercedValue = value;
                    if (coercedValue.value.rawAsBig) {
                        return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: {
                                asString: coercedValue.value.asBig.toFixed(),
                                rawAsString: coercedValue.value.rawAsBig.toFixed()
                            } });
                    }
                    else {
                        return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: {
                                asString: coercedValue.value.asBig.toFixed()
                            } });
                    }
                }
                case "enum": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: {
                            name: coercedValue.value.name,
                            numericAsString: coercedValue.value.numericAsBN.toString()
                        } });
                }
                case "array": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: coercedValue.value.map(serializeUntiedResult) });
                }
                case "mapping": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: coercedValue.value.map(({ key, value }) => ({
                            key: (serializeUntiedResult(key)),
                            value: serializeUntiedResult(value)
                        })) });
                }
                case "struct": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: coercedValue.value.map(({ name, value: element }) => ({
                            name,
                            value: serializeUntiedResult(element)
                        })) });
                }
                case "tuple": {
                    //had to split this from struct due to TS :-/
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: coercedValue.value.map(({ name, value: element }) => ({
                            name,
                            value: serializeUntiedResult(element)
                        })) });
                }
                case "magic": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: Object.assign({}, ...Object.entries(coercedValue.value).map(([name, element]) => ({
                            [name]: serializeUntiedResult(element)
                        }))) });
                }
                case "type": {
                    switch (value.type.type.typeClass) {
                        case "contract": {
                            let coercedValue = value;
                            return Object.assign(Object.assign({}, coercedValue), { type: (serializedType), value: coercedValue.value.map(({ name, value: element }) => ({
                                    name,
                                    value: serializeUntiedResult(element)
                                })) });
                        }
                        case "enum": {
                            let coercedValue = value;
                            return Object.assign(Object.assign({}, coercedValue), { type: (serializedType), value: (coercedValue.value.map(serializeUntiedResult)) });
                        }
                    }
                }
                case "contract": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: serializeContractValueInfo(coercedValue.value) });
                }
                case "function":
                    switch (value.type.visibility) {
                        case "external": {
                            let coercedValue = value;
                            return Object.assign(Object.assign({}, coercedValue), { type: serializedType, value: Object.assign(Object.assign({}, coercedValue.value), { contract: serializeContractValueInfo(coercedValue.value.contract) }) });
                        }
                        case "internal": {
                            let coercedValue = value;
                            if (coercedValue.value.kind === "function") {
                                return Object.assign(Object.assign({}, coercedValue), { type: (serializedType), value: Object.assign(Object.assign({}, coercedValue.value), { context: (serializeType(coercedValue.value.context)), definedIn: (serializeType(coercedValue.value.definedIn)) }) });
                            }
                            else {
                                return Object.assign(Object.assign({}, coercedValue), { type: (serializedType), value: Object.assign(Object.assign({}, coercedValue.value), { context: (serializeType(coercedValue.value.context)) }) });
                            }
                        }
                    }
                default:
                    return Object.assign(Object.assign({}, value), { type: serializedType });
            }
        case "error":
            switch (value.error.kind) {
                case "BoolOutOfRangeError":
                    return {
                        type: serializedType,
                        kind: "error",
                        error: {
                            kind: "BoolOutOfRangeError",
                            rawAsString: value.error.rawAsBN.toString()
                        }
                    };
                case "EnumOutOfRangeError":
                case "EnumNotFoundDecodingError":
                    return {
                        type: serializedType,
                        kind: "error",
                        error: {
                            kind: value.error.kind,
                            type: serializeType(value.error.type),
                            rawAsString: value.error.rawAsBN.toString()
                        }
                    };
                case "NoSuchInternalFunctionError":
                case "DeployedFunctionInConstructorError":
                case "MalformedInternalFunctionError":
                    return {
                        type: (serializedType),
                        kind: "error",
                        error: Object.assign(Object.assign({}, value.error), { context: (serializeType(value.error.context)) })
                    };
                case "UserDefinedTypeNotFoundError":
                    return {
                        type: serializedType,
                        kind: "error",
                        error: Object.assign(Object.assign({}, value.error), { type: serializeType(value.error.type) })
                    };
                case "ReadErrorStorage":
                    return {
                        type: serializedType,
                        kind: "error",
                        error: Object.assign(Object.assign({}, value.error), { range: serializeRange(value.error.range) })
                    };
                case "OverlongArraysAndStringsNotImplementedError":
                    return {
                        type: serializedType,
                        kind: "error",
                        error: value.error.dataLength !== undefined
                            ? {
                                kind: "OverlongArraysAndStringsNotImplementedError",
                                dataLength: value.error.dataLength,
                                lengthAsString: value.error.lengthAsBN.toString()
                            }
                            : {
                                kind: "OverlongArraysAndStringsNotImplementedError",
                                lengthAsString: value.error.lengthAsBN.toString()
                            }
                    };
                case "OverlargePointersNotImplementedError":
                    return {
                        type: serializedType,
                        kind: "error",
                        error: {
                            kind: "OverlargePointersNotImplementedError",
                            pointerAsString: value.error.pointerAsBN.toString()
                        }
                    };
                default:
                    return value; //blech
            }
    }
}
function serializeContractValueInfo(info) {
    switch (info.kind) {
        case "unknown":
            return info;
        case "known":
            return Object.assign(Object.assign({}, info), { class: (serializeType(info.class)) });
    }
}
function serializeRange(range) {
    return Object.assign(Object.assign({}, range), { from: Object.assign(Object.assign({}, range.from), { slot: serializeSlot(range.from.slot) }), to: range.to
            ? Object.assign(Object.assign({}, range.to), { slot: serializeSlot(range.to.slot) }) : undefined });
}
function serializeSlot(slot) {
    return Object.assign(Object.assign({}, slot), { path: slot.path ? serializeSlot(slot.path) : undefined, key: slot.key
            ? (serializeUntiedResult(slot.key))
            : undefined, offsetAsString: slot.offset.toString() });
}
//DESERIALIZATION (apologies for copypaste)
function deserializeResult(value) {
    return circularity_1.tie(deserializeToUntiedResult(value));
}
exports.deserializeResult = deserializeResult;
function deserializeType(dataType) {
    switch (dataType.typeClass) {
        case "array":
            switch (dataType.kind) {
                case "static":
                    return {
                        typeClass: "array",
                        kind: "static",
                        baseType: deserializeType(dataType.baseType),
                        location: dataType.location,
                        typeHint: dataType.typeHint,
                        length: new bn_js_1.default(dataType.lengthAsString)
                    };
                case "dynamic":
                    return Object.assign(Object.assign({}, dataType), { baseType: deserializeType(dataType.baseType) });
            }
            break; //for TS
        case "struct":
            if (dataType.memberTypes !== undefined) {
                return Object.assign(Object.assign({}, dataType), { memberTypes: dataType.memberTypes.map(({ name, type: memberType }) => ({
                        name,
                        type: deserializeType(memberType)
                    })) });
            }
            else {
                return dataType; //ugh Typescript
            }
        case "tuple":
            return Object.assign(Object.assign({}, dataType), { memberTypes: dataType.memberTypes.map(({ name, type: memberType }) => ({
                    name,
                    type: deserializeType(memberType)
                })) });
        case "mapping":
            return Object.assign(Object.assign({}, dataType), { valueType: deserializeType(dataType.valueType), keyType: deserializeType(dataType.keyType) });
        case "function":
            switch (dataType.visibility) {
                case "internal":
                    return Object.assign(Object.assign({}, dataType), { inputParameterTypes: dataType.inputParameterTypes.map(deserializeType), outputParameterTypes: dataType.outputParameterTypes.map(deserializeType) });
                case "external":
                    switch (dataType.kind) {
                        case "specific":
                            return Object.assign(Object.assign({}, dataType), { inputParameterTypes: dataType.inputParameterTypes.map(deserializeType), outputParameterTypes: dataType.outputParameterTypes.map(deserializeType) });
                        case "general":
                            return dataType;
                    }
                    break; //for TS
            }
            break; //for TS
        case "magic":
            if (dataType.memberTypes !== undefined) {
                return Object.assign(Object.assign({}, dataType), { memberTypes: Object.assign({}, ...Object.entries(dataType.memberTypes).map(([name, memberType]) => ({
                        [name]: deserializeType(memberType)
                    }))) });
            }
            else {
                return dataType; //ugh
            }
        case "type":
            switch (dataType.type.typeClass) {
                case "contract":
                    let coercedType = (dataType);
                    if (coercedType.stateVariableTypes !== undefined) {
                        return Object.assign(Object.assign({}, coercedType), { stateVariableTypes: coercedType.stateVariableTypes.map(({ name, type: stateVariableType }) => ({
                                name,
                                type: deserializeType(stateVariableType)
                            })) });
                    }
                    else {
                        return coercedType; //fricking TypeScript
                    }
                case "enum":
                    return dataType;
            }
        default:
            return dataType;
    }
}
exports.deserializeType = deserializeType;
function deserializeToUntiedResult(value) {
    let deserializedType = deserializeType(value.type);
    switch (value.kind) {
        case "value":
            switch (value.type.typeClass) {
                case "uint":
                case "int": {
                    let coercedValue = value;
                    if (coercedValue.value.rawAsString !== undefined) {
                        return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: {
                                asBN: new bn_js_1.default(coercedValue.value.asString),
                                rawAsBN: new bn_js_1.default(coercedValue.value.rawAsString)
                            } });
                    }
                    else {
                        return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: {
                                asBN: new bn_js_1.default(coercedValue.value.asString)
                            } });
                    }
                }
                case "fixed":
                case "ufixed": {
                    let coercedValue = value;
                    if (coercedValue.value.rawAsString !== undefined) {
                        return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: {
                                asBig: new big_js_1.default(coercedValue.value.asString),
                                rawAsBig: new big_js_1.default(coercedValue.value.rawAsString)
                            } });
                    }
                    else {
                        return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: {
                                asBig: new big_js_1.default(coercedValue.value.asString)
                            } });
                    }
                }
                case "enum": {
                    let coercedValue = value;
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: {
                            name: coercedValue.value.name,
                            numericAsBN: new bn_js_1.default(coercedValue.value.numericAsString)
                        } });
                }
                case "array": {
                    let coercedValue = (value);
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: coercedValue.value.map(deserializeToUntiedResult) });
                }
                case "mapping": {
                    let coercedValue = (value);
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: coercedValue.value.map(({ key, value }) => ({
                            key: (deserializeToUntiedResult(key)),
                            value: deserializeToUntiedResult(value)
                        })) });
                }
                case "struct": {
                    let coercedValue = (value);
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: coercedValue.value.map(({ name, value: element }) => ({
                            name,
                            value: deserializeToUntiedResult(element)
                        })) });
                }
                case "tuple": {
                    //had to split this from struct due to TS :-/
                    let coercedValue = (value);
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: coercedValue.value.map(({ name, value: element }) => ({
                            name,
                            value: deserializeToUntiedResult(element)
                        })) });
                }
                case "magic": {
                    let coercedValue = (value);
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: Object.assign({}, ...Object.entries(coercedValue.value).map(([name, element]) => ({
                            [name]: deserializeToUntiedResult(element)
                        }))) });
                }
                case "type": {
                    switch (value.type.type.typeClass) {
                        case "contract": {
                            let coercedValue = value;
                            return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: coercedValue.value.map(({ name, value: element }) => ({
                                    name,
                                    value: deserializeToUntiedResult(element)
                                })) });
                        }
                        case "enum": {
                            let coercedValue = value;
                            return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: (coercedValue.value.map(deserializeToUntiedResult)) });
                        }
                    }
                }
                case "contract": {
                    let coercedValue = (value);
                    return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: deserializeContractValueInfo(coercedValue.value) });
                }
                case "function":
                    switch (value.type.visibility) {
                        case "external": {
                            let coercedValue = value;
                            return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: Object.assign(Object.assign({}, coercedValue.value), { contract: deserializeContractValueInfo(coercedValue.value.contract) }) });
                        }
                        case "internal": {
                            let coercedValue = value;
                            if (coercedValue.value.kind === "function") {
                                return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: Object.assign(Object.assign({}, coercedValue.value), { context: (deserializeType(coercedValue.value.context)), definedIn: (deserializeType(coercedValue.value.definedIn)) }) });
                            }
                            else {
                                return Object.assign(Object.assign({}, coercedValue), { type: deserializedType, value: Object.assign(Object.assign({}, coercedValue.value), { context: (deserializeType(coercedValue.value.context)) }) });
                            }
                        }
                    }
                default:
                    return Object.assign(Object.assign({}, value), { type: deserializedType });
            }
        case "error":
            switch (value.error.kind) {
                case "BoolOutOfRangeError":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: {
                            kind: "BoolOutOfRangeError",
                            rawAsBN: new bn_js_1.default(value.error.rawAsString)
                        }
                    };
                case "EnumOutOfRangeError":
                case "EnumNotFoundDecodingError":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: {
                            kind: value.error.kind,
                            type: deserializeType(value.error.type),
                            rawAsBN: new bn_js_1.default(value.error.rawAsString)
                        }
                    };
                case "NoSuchInternalFunctionError":
                case "DeployedFunctionInConstructorError":
                case "MalformedInternalFunctionError":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: Object.assign(Object.assign({}, value.error), { context: (deserializeType(value.error.context)) })
                    };
                case "UserDefinedTypeNotFoundError":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: Object.assign(Object.assign({}, value.error), { type: deserializeType(value.error.type) })
                    };
                case "ReadErrorStorage":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: Object.assign(Object.assign({}, value.error), { range: deserializeRange(value.error.range) })
                    };
                case "OverlongArraysAndStringsNotImplementedError":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: value.error.dataLength !== undefined
                            ? {
                                kind: "OverlongArraysAndStringsNotImplementedError",
                                dataLength: value.error.dataLength,
                                lengthAsBN: new bn_js_1.default(value.error.lengthAsString)
                            }
                            : {
                                kind: "OverlongArraysAndStringsNotImplementedError",
                                lengthAsBN: new bn_js_1.default(value.error.lengthAsString)
                            }
                    };
                case "OverlargePointersNotImplementedError":
                    return {
                        type: deserializedType,
                        kind: "error",
                        error: {
                            kind: "OverlargePointersNotImplementedError",
                            pointerAsBN: new bn_js_1.default(value.error.pointerAsString)
                        }
                    };
                default:
                    return value; //blech
            }
    }
}
function deserializeContractValueInfo(info) {
    switch (info.kind) {
        case "unknown":
            return info;
        case "known":
            return Object.assign(Object.assign({}, info), { class: deserializeType(info.class) });
    }
}
function deserializeRange(range) {
    return Object.assign(Object.assign({}, range), { from: Object.assign(Object.assign({}, range.from), { slot: deserializeSlot(range.from.slot) }), to: range.to
            ? Object.assign(Object.assign({}, range.to), { slot: deserializeSlot(range.to.slot) }) : undefined });
}
function deserializeSlot(slot) {
    return Object.assign(Object.assign({}, slot), { path: slot.path ? deserializeSlot(slot.path) : undefined, key: slot.key
            ? deserializeToUntiedResult(slot.key)
            : undefined, offset: new bn_js_1.default(slot.offsetAsString) });
}
//# sourceMappingURL=serial.js.map