"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ContractBeingDecodedHasNoNodeError extends Error {
    constructor(contractName) {
        const message = `Contract ${contractName} does not appear to have been compiled with Solidity (cannot locate contract node)`;
        super(message);
        this.name = "ContractBeingDecodedHasNoNodeError";
    }
}
exports.ContractBeingDecodedHasNoNodeError = ContractBeingDecodedHasNoNodeError;
class ContractAllocationFailedError extends Error {
    constructor(id, contractName) {
        super(`No allocation found for contract ID ${id} (${contractName})`);
        this.name = "ContractAllocationFailedError";
    }
}
exports.ContractAllocationFailedError = ContractAllocationFailedError;
//# sourceMappingURL=errors.js.map