"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
/** @hidden */
const debug = debug_1.default("codec:interface");
const Decoders = __importStar(require("./decoders"));
exports.Decoders = Decoders;
const Errors = __importStar(require("./errors"));
exports.Errors = Errors;
function forContractInstance(contract, relevantContracts, provider, address) {
    return __awaiter(this, void 0, void 0, function* () {
        let contractDecoder = yield forContract(contract, relevantContracts, provider);
        let instanceDecoder = yield contractDecoder.forInstance(address);
        return instanceDecoder;
    });
}
exports.forContractInstance = forContractInstance;
function forContract(contract, relevantContracts, provider) {
    return __awaiter(this, void 0, void 0, function* () {
        let contracts = relevantContracts.includes(contract)
            ? relevantContracts
            : [contract, ...relevantContracts];
        let wireDecoder = yield forProject(contracts, provider);
        let contractDecoder = new Decoders.ContractDecoder(contract, wireDecoder);
        yield contractDecoder.init();
        return contractDecoder;
    });
}
exports.forContract = forContract;
function forProject(contracts, provider) {
    return __awaiter(this, void 0, void 0, function* () {
        return new Decoders.WireDecoder(contracts, provider);
    });
}
exports.forProject = forProject;
function forContractWithDecoder(contract, decoder) {
    return __awaiter(this, void 0, void 0, function* () {
        let contractDecoder = new Decoders.ContractDecoder(contract, decoder);
        yield contractDecoder.init();
        return contractDecoder;
    });
}
exports.forContractWithDecoder = forContractWithDecoder;
//# sourceMappingURL=index.js.map