/**
 * read word from memory
 *
 * requires `byte` to be a multiple of WORD_SIZE (32)
 *
 * @param memory - Uint8Array
 * @param offset - number
 * @return {BN}
 */
export declare function read(memory: Uint8Array, offset: number): Uint8Array;
/**
 * read <length> amount of bytes from memory, starting at <offset>
 *
 * @param memory - Uint8Array
 * @param offset - number
 * @param length - number
 */
export declare function readBytes(memory: Uint8Array, offset: number, length: number): Uint8Array;
