"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const Evm = __importStar(require("../evm"));
const errors_1 = require("../errors");
/**
 * read word from memory
 *
 * requires `byte` to be a multiple of WORD_SIZE (32)
 *
 * @param memory - Uint8Array
 * @param offset - number
 * @return {BN}
 */
function read(memory, offset) {
    return readBytes(memory, offset, Evm.Utils.WORD_SIZE);
}
exports.read = read;
/**
 * read <length> amount of bytes from memory, starting at <offset>
 *
 * @param memory - Uint8Array
 * @param offset - number
 * @param length - number
 */
function readBytes(memory, offset, length) {
    if (!Number.isSafeInteger(offset + length)) {
        throw new errors_1.DecodingError({
            kind: "ReadErrorBytes",
            start: offset,
            length
        });
    }
    // grab `length` bytes no matter what, here fill this array
    var bytes = new Uint8Array(length);
    bytes.fill(0); //fill it wil zeroes to start
    //if the start is beyond the end of memory, just return those 0s
    if (offset >= memory.length) {
        return bytes;
    }
    // if we're reading past the end of memory, truncate the length to read
    let excess = offset + length - memory.length;
    let readLength;
    if (excess > 0) {
        readLength = memory.length - offset;
    }
    else {
        readLength = length;
    }
    //get the (truncated) memory
    let existing = new Uint8Array(memory.buffer, offset, readLength);
    //copy it into our buffer
    bytes.set(existing);
    return bytes;
}
exports.readBytes = readBytes;
//# sourceMappingURL=bytes.js.map