"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const storage = __importStar(require("./storage"));
const bytes = __importStar(require("./bytes"));
const stack = __importStar(require("./stack"));
const constant = __importStar(require("./constant"));
function* read(pointer, state) {
    switch (pointer.location) {
        case "stack":
            return stack.readStack(state.stack, pointer.from, pointer.to);
        case "storage":
            return yield* storage.readRange(state.storage, pointer.range);
        case "memory":
            return bytes.readBytes(state.memory, pointer.start, pointer.length);
        case "calldata":
            return bytes.readBytes(state.calldata, pointer.start, pointer.length);
        case "eventdata":
            return bytes.readBytes(state.eventdata, pointer.start, pointer.length);
        case "stackliteral":
            //nothing to do, just return it
            return pointer.literal;
        case "definition":
            return constant.readDefinition(pointer.definition);
        case "special":
            //this one is simple enough to inline
            //not bothering with error handling on this one as I don't expect errors
            return state.specials[pointer.special];
        case "eventtopic":
            //this one is simple enough to inline as well; similarly not bothering
            //with error handling
            return state.eventtopics[pointer.topic];
    }
}
exports.default = read;
//# sourceMappingURL=index.js.map