import * as Storage from "../storage/types";
import { DecoderRequest } from "../types";
import * as Evm from "../evm";
/**
 * read slot from storage
 *
 * @param slot - see slotAddress() code to understand how these work
 * @param offset - for array, offset from the keccak determined location
 */
export declare function read(storage: Evm.WordMapping, slot: Storage.Slot): Generator<DecoderRequest, Uint8Array, Uint8Array>;
/**
 * read all bytes in some range.
 *
 * parameters `from` and `to` are objects with the following properties:
 *
 *   slot - see the slotAddress() code to understand how these work
 *
 *     ref: https://solidity.readthedocs.io/en/v0.4.23/miscellaneous.html#layout-of-state-variables-in-storage
 *     (search "concatenation")
 *
 *  index - (default: 0) byte index in word
 *
 * @param from - location (see ^)
 * @param to - location (see ^). inclusive.
 * @param length - instead of `to`, number of bytes after `from`
 */
export declare function readRange(storage: Evm.WordMapping, range: Storage.Range): Generator<DecoderRequest, Uint8Array, Uint8Array>;
