"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:utils:abi");
const evm_1 = require("./evm");
const ast_1 = require("../types/ast");
const definition2abi_1 = require("./definition2abi");
const AbiTypes = __importStar(require("../types/abi"));
const web3_1 = __importDefault(require("web3"));
//NOTE: SchemaAbi is kind of loose and a pain to use.
//So we'll generally coerce things to Abi before use.
//(we combine this with adding a "function" tag for
//entries that lack it)
var AbiUtils;
(function (AbiUtils) {
    AbiUtils.DEFAULT_CONSTRUCTOR_ABI = {
        type: "constructor",
        inputs: [],
        stateMutability: "nonpayable",
        payable: false
    };
    AbiUtils.DEFAULT_FALLBACK_ABI = {
        type: "fallback",
        stateMutability: "nonpayable",
        payable: false
    };
    function schemaAbiToAbi(abiLoose) {
        return abiLoose.map(entry => entry.type
            ? entry
            : Object.assign({ type: "function" }, entry));
    }
    AbiUtils.schemaAbiToAbi = schemaAbiToAbi;
    //note the return value only includes functions!
    function computeSelectors(abi) {
        if (abi === undefined) {
            return undefined;
        }
        return Object.assign({}, ...abi.filter((abiEntry) => abiEntry.type === "function").map((abiEntry) => ({ [abiSelector(abiEntry)]: abiEntry })));
    }
    AbiUtils.computeSelectors = computeSelectors;
    //does this ABI have a payable fallback function?
    function abiHasPayableFallback(abi) {
        if (abi === undefined) {
            return undefined;
        }
        return abiMutability(getFallbackEntry(abi)) === "payable";
    }
    AbiUtils.abiHasPayableFallback = abiHasPayableFallback;
    function abiHasFallback(abi) {
        return abi.some((abiEntry) => abiEntry.type === "fallback");
    }
    AbiUtils.abiHasFallback = abiHasFallback;
    //gets the fallback entry; if there isn't one, returns a default one
    function getFallbackEntry(abi) {
        //no idea why TS's type inference is failing on this one...
        return abi.find(abiEntry => abiEntry.type === "fallback") || AbiUtils.DEFAULT_FALLBACK_ABI;
    }
    AbiUtils.getFallbackEntry = getFallbackEntry;
    function fallbackAbiForPayability(payable) {
        return {
            type: "fallback",
            stateMutability: payable ? "payable" : "nonpayable",
            payable
        };
    }
    AbiUtils.fallbackAbiForPayability = fallbackAbiForPayability;
    //shim for old abi versions
    function abiMutability(abiEntry) {
        if (abiEntry.stateMutability !== undefined) {
            return abiEntry.stateMutability;
        }
        if (abiEntry.payable) {
            return "payable";
        }
        if (abiEntry.type === "function" && abiEntry.constant) {
            return "view";
        }
        return "nonpayable";
    }
    //NOTE: this function returns the written out SIGNATURE, not the SELECTOR
    function abiSignature(abiEntry) {
        return abiEntry.name + abiTupleSignature(abiEntry.inputs);
    }
    AbiUtils.abiSignature = abiSignature;
    function abiTupleSignature(parameters) {
        let components = parameters.map(abiTypeSignature);
        return "(" + components.join(",") + ")";
    }
    AbiUtils.abiTupleSignature = abiTupleSignature;
    function abiTypeSignature(parameter) {
        let tupleMatch = parameter.type.match(/tuple(.*)/);
        if (tupleMatch === null) { //does not start with "tuple"
            return parameter.type;
        }
        else {
            let tail = tupleMatch[1]; //everything after "tuple"
            let tupleSignature = abiTupleSignature(parameter.components);
            return tupleSignature + tail;
        }
    }
    function abiSelector(abiEntry) {
        let signature = abiSignature(abiEntry);
        //NOTE: web3's soliditySha3 has a problem if the empty
        //string is passed in.  Fortunately, that should never happen here.
        let hash = web3_1.default.utils.soliditySha3({ type: "string", value: signature });
        switch (abiEntry.type) {
            case "event":
                return hash;
            case "function":
                return hash.slice(0, 2 + 2 * evm_1.EVM.SELECTOR_SIZE); //arithmetic to account for hex string
        }
    }
    AbiUtils.abiSelector = abiSelector;
    //note: undefined does not match itself :P
    function abisMatch(entry1, entry2) {
        //we'll consider two abi entries to match if they have the same
        //type, name (if applicable), and inputs (if applicable).
        //since there's already a signature function, we can just use that.
        if (!entry1 || !entry2) {
            return false;
        }
        if (entry1.type !== entry2.type) {
            return false;
        }
        switch (entry1.type) {
            case "function":
            case "event":
                return abiSignature(entry1) === abiSignature(entry2);
            case "constructor":
                return abiTupleSignature(entry1.inputs) === abiTupleSignature(entry2.inputs);
            case "fallback":
                return true;
        }
    }
    AbiUtils.abisMatch = abisMatch;
    function definitionMatchesAbi(abiEntry, definition, referenceDeclarations) {
        try {
            return abisMatch(abiEntry, definition2abi_1.definitionToAbi(definition, referenceDeclarations));
        }
        catch (_) {
            return false; //if an exception occurs, well, that's not a match!
        }
    }
    AbiUtils.definitionMatchesAbi = definitionMatchesAbi;
    function topicsCount(abiEntry) {
        let selectorCount = abiEntry.anonymous ? 0 : 1; //if the event is not anonymous, we must account for the selector
        return abiEntry.inputs.filter(({ indexed }) => indexed).length + selectorCount;
    }
    AbiUtils.topicsCount = topicsCount;
})(AbiUtils = exports.AbiUtils || (exports.AbiUtils = {}));
//# sourceMappingURL=abi.js.map