"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:utils:evm");
const web3_1 = __importDefault(require("web3"));
const conversion_1 = require("./conversion");
const constants_1 = require("./constants");
var EVM;
(function (EVM) {
    //the following constants are re-exported from EVM for convenience
    EVM.WORD_SIZE = constants_1.Constants.WORD_SIZE;
    EVM.ADDRESS_SIZE = constants_1.Constants.ADDRESS_SIZE;
    EVM.SELECTOR_SIZE = constants_1.Constants.SELECTOR_SIZE;
    EVM.PC_SIZE = constants_1.Constants.PC_SIZE;
    EVM.MAX_WORD = constants_1.Constants.MAX_WORD;
    EVM.ZERO_ADDRESS = constants_1.Constants.ZERO_ADDRESS;
    //beware of using this for generic strings! (it's fine for bytestrings, or
    //strings representing numbers) if you want to use this on a generic string,
    //you should pass in {type: "string", value: theString} instead of the string
    //itself.
    //(maybe I should add a rawKeccak256 function, using sha3 instead of
    //soliditysha3?  not seeing the need atm though)
    function keccak256(...args) {
        // debug("args %o", args);
        const rawSha = web3_1.default.utils.soliditySha3(...args);
        debug("rawSha %o", rawSha);
        let sha;
        if (rawSha === null) {
            sha = ""; //HACK, I guess?
        }
        else {
            sha = rawSha.replace(/0x/, "");
        }
        return conversion_1.Conversion.toBN(sha);
    }
    EVM.keccak256 = keccak256;
    //checks if two bytearrays (which may be undefined) are equal.
    //does not consider undefined to be equal to itself.
    function equalData(bytes1, bytes2) {
        if (!bytes1 || !bytes2) {
            return false;
        }
        if (bytes1.length !== bytes2.length) {
            return false;
        }
        for (let i = 0; i < bytes1.length; i++) {
            if (bytes1[i] !== bytes2[i]) {
                return false;
            }
        }
        return true;
    }
    EVM.equalData = equalData;
})(EVM = exports.EVM || (exports.EVM = {}));
//# sourceMappingURL=evm.js.map