"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const debug = debug_1.default("codec:utils:wrap");
const web3_1 = __importDefault(require("web3"));
const bn_js_1 = __importDefault(require("bn.js"));
const compiler_1 = require("../types/compiler");
const ast_1 = require("../types/ast");
const maketype_1 = require("./maketype");
const format_1 = require("../format");
//Function for wrapping a value as an ElementaryValue
//WARNING: this function does not check its inputs! Please check before using!
//How to use:
//numbers may be BN, number, or numeric string
//strings should be given as strings. duh.
//bytes should be given as hex strings beginning with "0x"
//addresses are like bytes; checksum case is not required
//booleans may be given either as booleans, or as string "true" or "false"
//[NOTE: in the future this function will:
//1. check its inputs,
//2. take a slightly different input format,
//3. also be named differently and... it'll be different :P ]
function wrapElementaryViaDefinition(value, definition, compiler) {
    let dataType = maketype_1.MakeType.definitionToType(definition, compiler, null); //force location to undefined
    return wrapElementaryValue(value, dataType);
}
exports.wrapElementaryViaDefinition = wrapElementaryViaDefinition;
function wrapElementaryValue(value, dataType) {
    switch (dataType.typeClass) {
        case "string":
            return {
                type: dataType,
                kind: "value",
                value: {
                    kind: "valid",
                    asString: value
                }
            };
        case "bytes":
            //NOTE: in the future should add padding for static case
            return {
                type: dataType,
                kind: "value",
                value: {
                    asHex: value
                }
            };
        case "address":
            value = web3_1.default.utils.toChecksumAddress(value);
            return {
                type: dataType,
                kind: "value",
                value: {
                    asAddress: value
                }
            };
        case "uint":
        case "int":
            if (value instanceof bn_js_1.default) {
                value = value.clone();
            }
            else {
                value = new bn_js_1.default(value);
            }
            return {
                type: dataType,
                kind: "value",
                value: {
                    asBN: value
                }
            };
        case "bool":
            if (typeof value === "string") {
                value = value !== "false";
            }
            return {
                type: dataType,
                kind: "value",
                value: {
                    asBoolean: value
                }
            };
        //fixed and ufixed are not handled for now!
    }
}
exports.wrapElementaryValue = wrapElementaryValue;
//# sourceMappingURL=wrap.js.map