"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const abi_1 = require("./abi");
const conversion_1 = require("./conversion");
const evm_1 = require("./evm");
function getContractNode(contract) {
    return (contract.ast || { nodes: [] }).nodes.find((contractNode) => contractNode.nodeType === "ContractDefinition"
        && (contractNode.name === contract.contractName
            || contractNode.name === contract.contract_name));
}
exports.getContractNode = getContractNode;
function makeContext(contract, node, isConstructor = false) {
    const abi = abi_1.AbiUtils.schemaAbiToAbi(contract.abi);
    const binary = isConstructor ? contract.bytecode : contract.deployedBytecode;
    const hash = conversion_1.Conversion.toHexString(evm_1.EVM.keccak256({ type: "string",
        value: binary
    }));
    return {
        context: hash,
        contractName: contract.contractName,
        binary,
        contractId: node ? node.id : undefined,
        contractKind: contractKind(contract, node),
        isConstructor,
        abi: abi_1.AbiUtils.computeSelectors(abi),
        payable: abi_1.AbiUtils.abiHasPayableFallback(abi),
        hasFallback: abi_1.AbiUtils.abiHasFallback(abi),
        compiler: contract.compiler
    };
}
exports.makeContext = makeContext;
//attempts to determine if the given contract is a library or not
function contractKind(contract, node) {
    //first: if we have a node, use its listed contract kind
    if (node) {
        return node.contractKind;
    }
    //next: check the contract kind field on the contract object itself, if it exists.
    //however this isn't implemented yet so we'll skip it.
    //next: if we have no direct info on the contract kind, but we do
    //have the deployed bytecode, we'll use a HACK:
    //we'll assume it's an ordinary contract, UNLESS its deployed bytecode begins with
    //PUSH20 followed by 20 0s, in which case we'll assume it's a library
    //(note: this will fail to detect libraries from before Solidity 0.4.20)
    if (contract.deployedBytecode) {
        const pushAddressInstruction = (0x60 +
            evm_1.EVM.ADDRESS_SIZE -
            1).toString(16); //"73"
        const libraryString = "0x" + pushAddressInstruction + "00".repeat(evm_1.EVM.ADDRESS_SIZE);
        return contract.deployedBytecode.startsWith(libraryString) ? "library" : "contract";
    }
    //finally, in the absence of anything to go on, we'll assume it's an ordinary contract
    return "contract";
}
//# sourceMappingURL=interface.js.map