'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

var Subprovider = require('./subprovider.js');

// wraps a json-rpc-engine middleware in a subprovider interface

var JsonRpcEngineMiddlewareSubprovider = function (_Subprovider) {
  _inherits(JsonRpcEngineMiddlewareSubprovider, _Subprovider);

  // take a constructorFn to call once we have a reference to the engine
  function JsonRpcEngineMiddlewareSubprovider(constructorFn) {
    _classCallCheck(this, JsonRpcEngineMiddlewareSubprovider);

    var _this = _possibleConstructorReturn(this, (JsonRpcEngineMiddlewareSubprovider.__proto__ || Object.getPrototypeOf(JsonRpcEngineMiddlewareSubprovider)).call(this));

    if (!constructorFn) throw new Error('JsonRpcEngineMiddlewareSubprovider - no constructorFn specified');
    _this._constructorFn = constructorFn;
    return _this;
  }

  // this is called once the subprovider has been added to the provider engine


  _createClass(JsonRpcEngineMiddlewareSubprovider, [{
    key: 'setEngine',
    value: function setEngine(engine) {
      if (this.middleware) throw new Error('JsonRpcEngineMiddlewareSubprovider - subprovider added to engine twice');
      var blockTracker = engine._blockTracker;
      var middleware = this._constructorFn({ engine: engine, provider: engine, blockTracker: blockTracker });
      if (!middleware) throw new Error('JsonRpcEngineMiddlewareSubprovider - _constructorFn did not return middleware');
      if (typeof middleware !== 'function') throw new Error('JsonRpcEngineMiddlewareSubprovider - specified middleware is not a function');
      this.middleware = middleware;
    }
  }, {
    key: 'handleRequest',
    value: function handleRequest(req, provEngNext, provEngEnd) {
      var res = { id: req.id };
      this.middleware(req, res, middlewareNext, middlewareEnd);

      function middlewareNext(handler) {
        provEngNext(function (err, result, cb) {
          // update response object with result or error
          if (err) {
            delete res.result;
            res.error = { message: err.message || err };
          } else {
            res.result = result;
          }
          // call middleware's next handler (even if error)
          if (handler) {
            handler(cb);
          } else {
            cb();
          }
        });
      }

      function middlewareEnd(err) {
        if (err) return provEngEnd(err);
        provEngEnd(null, res.result);
      }
    }
  }]);

  return JsonRpcEngineMiddlewareSubprovider;
}(Subprovider);

module.exports = JsonRpcEngineMiddlewareSubprovider;