"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const envinfo_1 = __importDefault(require("envinfo"));
const webpack_cli_1 = __importDefault(require("webpack-cli"));
const webpack_cli_2 = require("webpack-cli");
const { logger, commands } = webpack_cli_2.utils;
const DEFAULT_DETAILS = {
    Binaries: ['Node', 'Yarn', 'npm'],
    Browsers: [
        'Brave Browser',
        'Chrome',
        'Chrome Canary',
        'Edge',
        'Firefox',
        'Firefox Developer Edition',
        'Firefox Nightly',
        'Internet Explorer',
        'Safari',
        'Safari Technology Preview',
    ],
    System: ['OS', 'CPU', 'Memory'],
    npmGlobalPackages: ['webpack', 'webpack-cli'],
    npmPackages: '*webpack*',
};
async function info(...args) {
    const cli = new webpack_cli_1.default();
    const { flags: infoFlags } = commands.find((cmd) => cmd.name === 'info');
    const parsedArgs = cli.argParser(infoFlags, args, true);
    const infoArgs = parsedArgs.opts;
    const envinfoConfig = {};
    if (parsedArgs.unknownArgs.length > 0) {
        logger.error(`Unknown argument: ${parsedArgs.unknownArgs}`);
        process.exit(2);
    }
    if (infoArgs.output) {
        // Remove quotes if exist
        const output = infoArgs.output.replace(/['"]+/g, '');
        switch (output) {
            case 'markdown':
                envinfoConfig['markdown'] = true;
                break;
            case 'json':
                envinfoConfig['json'] = true;
                break;
            default:
                logger.error(`'${infoArgs.output}' is not a valid value for output`);
                process.exit(2);
        }
    }
    let output = await envinfo_1.default.run(DEFAULT_DETAILS, envinfoConfig);
    output = output.replace(/npmPackages/g, 'Packages');
    output = output.replace(/npmGlobalPackages/g, 'Global Packages');
    const finalOutput = output;
    logger.raw(finalOutput);
    return finalOutput;
}
exports.default = info;
