"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 *
 * Get the devServer option from the user's compiler options
 *
 * @param {Object} compiler - webpack compiler
 * @param {Object} webpackArgs - webpack args
 *
 * @returns {Object}
 */
function getDevServerOptions(compiler) {
    const defaultOpts = {};
    const devServerOptions = [];
    const compilers = compiler.compilers || [compiler];
    compilers.forEach((comp) => {
        if (comp.options.devServer) {
            devServerOptions.push(comp.options.devServer);
        }
    });
    if (devServerOptions.length === 0) {
        devServerOptions.push(defaultOpts);
    }
    return devServerOptions;
}
exports.default = getDevServerOptions;
