"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 *
 * Merges CLI options and devServer options from config file
 *
 * @param {Object} cliOptions - devServer CLI args
 * @param {Object} devServerOptions - devServer config options
 *
 * @returns {Object} merged options object
 */
function mergeOptions(cliOptions, devServerOptions) {
    // CLI options should take precedence over devServer options,
    // and CLI options should have no default values included
    const options = Object.assign(Object.assign({}, devServerOptions), cliOptions);
    if (devServerOptions.client && cliOptions.client) {
        // the user could set some client options in their devServer config,
        // then also specify client options on the CLI
        options.client = Object.assign(Object.assign({}, devServerOptions.client), cliOptions.client);
    }
    return options;
}
exports.default = mergeOptions;
