declare type WebpackCLIType = {
    getCoreFlags: Function;
    argParser: Function;
};
declare type ArgsType = {
    devServerArgs: object;
    webpackArgs: object;
};
/**
 *
 * Parses raw dev server CLI args
 *
 * @param {Object} cli - webpack CLI object
 * @param {Object[]} devServerFlags - devServer flags
 * @param {String[]} args - unparsed devServer args processed from the CLI
 *
 * @returns {Object} parsed webpack args and dev server args objects
 */
export default function parseArgs(cli: WebpackCLIType, args: string[]): ArgsType;
export {};
