"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const webpack_cli_1 = require("webpack-cli");
const { logger } = webpack_cli_1.utils;
/**
 *
 * Creates a devServer config from CLI args
 *
 * @param {Object} args - devServer args
 *
 * @returns {Object} valid devServer options object
 */
function createConfig(args) {
    const options = Object.assign({}, args);
    let isDevServer4 = false, devServerVersion;
    try {
        // eslint-disable-next-line node/no-extraneous-require
        devServerVersion = require('webpack-dev-server/package.json').version;
    }
    catch (err) {
        logger.error(`You need to install 'webpack-dev-server' for running 'webpack serve'.\n${err}`);
        process.exit(2);
    }
    isDevServer4 = devServerVersion.startsWith('4');
    if (options.clientLogging) {
        options.client = {
            logging: options.clientLogging,
        };
        // clientLogging is not a valid devServer option
        delete options.clientLogging;
    }
    if (isDevServer4 && options.hotOnly) {
        options.hot = 'only';
        // hotOnly is not a valid devServer option
        delete options.hotOnly;
    }
    return options;
}
exports.default = createConfig;
