"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const webpack_cli_1 = __importStar(require("webpack-cli"));
const startDevServer_1 = __importDefault(require("./startDevServer"));
const parseArgs_1 = __importDefault(require("./parseArgs"));
const { logger } = webpack_cli_1.utils;
/**
 *
 * Creates a webpack compiler and runs the devServer
 *
 * @param {String[]} args - args processed from the CLI
 * @returns {Function} invokes the devServer API
 */
function serve(...args) {
    try {
        // eslint-disable-next-line node/no-extraneous-require
        require('webpack-dev-server');
    }
    catch (err) {
        logger.error(`You need to install 'webpack-dev-server' for running 'webpack serve'.\n${err}`);
        process.exit(2);
    }
    const cli = new webpack_cli_1.default();
    const { webpackArgs, devServerArgs } = parseArgs_1.default(cli, args);
    cli.getCompiler(webpackArgs).then((compiler) => {
        startDevServer_1.default(compiler, devServerArgs);
    });
}
exports.default = serve;
