"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const webpack_cli_1 = require("webpack-cli");
const { logger } = webpack_cli_1.utils;
/**
 *
 * Parses raw dev server CLI args
 *
 * @param {Object} cli - webpack CLI object
 * @param {Object[]} devServerFlags - devServer flags
 * @param {String[]} args - unparsed devServer args processed from the CLI
 *
 * @returns {Object} parsed webpack args and dev server args objects
 */
function parseArgs(cli, args) {
    let devServerFlags;
    try {
        // eslint-disable-next-line node/no-extraneous-require
        devServerFlags = require('webpack-dev-server/bin/cli-flags').devServer;
    }
    catch (err) {
        logger.error(`You need to install 'webpack-dev-server' for running 'webpack serve'.\n${err}`);
        process.exit(2);
    }
    const core = cli.getCoreFlags();
    const parsedDevServerArgs = cli.argParser(devServerFlags, args, true);
    const devServerArgs = parsedDevServerArgs.opts;
    const parsedWebpackArgs = cli.argParser(core, parsedDevServerArgs.unknownArgs, true, process.title);
    const webpackArgs = parsedWebpackArgs.opts;
    // Add WEBPACK_SERVE environment variable
    if (webpackArgs.env) {
        webpackArgs.env.WEBPACK_SERVE = true;
    }
    else {
        webpackArgs.env = { WEBPACK_SERVE: true };
    }
    // pass along the 'hot' argument to the dev server if it exists
    if (webpackArgs && webpackArgs.hot !== undefined) {
        devServerArgs['hot'] = webpackArgs.hot;
    }
    if (parsedWebpackArgs.unknownArgs.length > 0) {
        parsedWebpackArgs.unknownArgs
            .filter((e) => e)
            .forEach((unknown) => {
            logger.error(`Unknown argument: ${unknown}`);
        });
        process.exit(2);
    }
    return {
        devServerArgs,
        webpackArgs,
    };
}
exports.default = parseArgs;
