"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const createConfig_1 = __importDefault(require("./createConfig"));
const getDevServerOptions_1 = __importDefault(require("./getDevServerOptions"));
const mergeOptions_1 = __importDefault(require("./mergeOptions"));
/**
 *
 * Starts the devServer
 *
 * @param {Object} compiler - a webpack compiler
 * @param {Object} devServerArgs - devServer args
 *
 * @returns {Object[]} array of resulting servers
 */
function startDevServer(compiler, devServerArgs) {
    // eslint-disable-next-line @typescript-eslint/no-var-requires, node/no-extraneous-require
    const Server = require('webpack-dev-server/lib/Server');
    const cliOptions = createConfig_1.default(devServerArgs);
    const devServerOptions = getDevServerOptions_1.default(compiler);
    const servers = [];
    const usedPorts = [];
    devServerOptions.forEach((devServerOpts) => {
        const options = mergeOptions_1.default(cliOptions, devServerOpts);
        options.host = options.host || 'localhost';
        options.port = options.port || 8080;
        const portNum = +options.port;
        if (usedPorts.find((port) => portNum === port)) {
            throw new Error('Unique ports must be specified for each devServer option in your webpack configuration. Alternatively, run only 1 devServer config using the --config-name flag to specify your desired config.');
        }
        usedPorts.push(portNum);
        const server = new Server(compiler, options);
        server.listen(options.port, options.host, (err) => {
            if (err) {
                throw err;
            }
        });
        servers.push(server);
    });
    return servers;
}
exports.default = startDevServer;
