"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LightReport = void 0;
const Report_1 = require("./Report");
class LightReport extends Report_1.Report {
    constructor({ configuration, stdout, suggestInstall = true }) {
        super();
        this.errorCount = 0;
        this.configuration = configuration;
        this.stdout = stdout;
        this.suggestInstall = suggestInstall;
    }
    static async start(opts, cb) {
        const report = new this(opts);
        try {
            await cb(report);
        }
        catch (error) {
            report.reportExceptionOnce(error);
        }
        finally {
            await report.finalize();
        }
        return report;
    }
    hasErrors() {
        return this.errorCount > 0;
    }
    exitCode() {
        return this.hasErrors() ? 1 : 0;
    }
    reportCacheHit(locator) {
    }
    reportCacheMiss(locator) {
    }
    startTimerSync(what, cb) {
        return cb();
    }
    async startTimerPromise(what, cb) {
        return await cb();
    }
    async startCacheReport(cb) {
        return await cb();
    }
    reportSeparator() {
    }
    reportInfo(name, text) {
    }
    reportWarning(name, text) {
    }
    reportError(name, text) {
        this.errorCount += 1;
        this.stdout.write(`${this.configuration.format(`➤`, `redBright`)} ${this.formatName(name)}: ${text}\n`);
    }
    reportProgress(progress) {
        const promise = Promise.resolve().then(async () => {
            // eslint-disable-next-line no-empty-pattern
            for await (const {} of progress) {
                // No need to do anything; we just want to consume the progress events
            }
        });
        const stop = () => {
            // Nothing to stop
        };
        return { ...promise, stop };
    }
    reportJson(data) {
        // Just ignore the json output
    }
    async finalize() {
        if (this.errorCount > 0) {
            this.stdout.write(`${this.configuration.format(`➤`, `redBright`)} Errors happened when preparing the environment required to run this command.\n`);
            if (this.suggestInstall) {
                this.stdout.write(`${this.configuration.format(`➤`, `redBright`)} This might be caused by packages being missing from the lockfile, in which case running "yarn install" might help.\n`);
            }
        }
    }
    formatName(name) {
        return `BR${name.toString(10).padStart(4, `0`)}`;
    }
}
exports.LightReport = LightReport;
