import { PortablePath } from '@yarnpkg/fslib';
import { Cache } from './Cache';
import { Configuration } from './Configuration';
import { Fetcher } from './Fetcher';
import { DependencyMeta } from './Manifest';
import { MessageName } from './MessageName';
import { Report } from './Report';
import { Resolver } from './Resolver';
import { Workspace } from './Workspace';
import { IdentHash, DescriptorHash, LocatorHash } from './types';
import { Descriptor, Ident, Locator, Package } from './types';
export declare type InstallOptions = {
    cache: Cache;
    fetcher?: Fetcher;
    resolver?: Resolver;
    report: Report;
    immutable?: boolean;
    lockfileOnly?: boolean;
    persistProject?: boolean;
};
export declare class Project {
    readonly configuration: Configuration;
    readonly cwd: PortablePath;
    /**
     * Is meant to be populated by the consumer. Should the descriptor referenced
     * by the key be requested, the descriptor referenced in the value will be
     * resolved instead. The resolved data will then be used as final resolution
     * for the initial descriptor.
     *
     * Note that the lockfile will contain the second descriptor but not the
     * first one (meaning that if you remove the alias during a subsequent
     * install, it'll be lost and the real package will be resolved / installed).
     */
    resolutionAliases: Map<DescriptorHash, DescriptorHash>;
    workspaces: Array<Workspace>;
    workspacesByCwd: Map<PortablePath, Workspace>;
    workspacesByIdent: Map<IdentHash, Workspace>;
    storedResolutions: Map<DescriptorHash, LocatorHash>;
    storedDescriptors: Map<DescriptorHash, Descriptor>;
    storedPackages: Map<LocatorHash, Package>;
    storedChecksums: Map<LocatorHash, string>;
    accessibleLocators: Set<LocatorHash>;
    originalPackages: Map<LocatorHash, Package>;
    optionalBuilds: Set<LocatorHash>;
    lockFileChecksum: string | null;
    static find(configuration: Configuration, startingCwd: PortablePath): Promise<{
        project: Project;
        workspace: Workspace | null;
        locator: Locator;
    }>;
    static generateBuildStateFile(buildState: Map<LocatorHash, string>, locatorStore: Map<LocatorHash, Locator>): string;
    constructor(projectCwd: PortablePath, { configuration }: {
        configuration: Configuration;
    });
    private setupResolutions;
    private setupWorkspaces;
    private addWorkspace;
    get topLevelWorkspace(): Workspace;
    tryWorkspaceByCwd(workspaceCwd: PortablePath): Workspace | null;
    getWorkspaceByCwd(workspaceCwd: PortablePath): Workspace;
    tryWorkspaceByFilePath(filePath: PortablePath): Workspace | null;
    getWorkspaceByFilePath(filePath: PortablePath): Workspace;
    tryWorkspaceByIdent(ident: Ident): Workspace | null;
    getWorkspaceByIdent(ident: Ident): Workspace;
    tryWorkspaceByDescriptor(descriptor: Descriptor): Workspace | null;
    getWorkspaceByDescriptor(descriptor: Descriptor): Workspace;
    tryWorkspaceByLocator(locator: Locator): Workspace | null;
    getWorkspaceByLocator(locator: Locator): Workspace;
    /**
     * Import the dependencies of each resolved workspace into their own
     * `Workspace` instance.
     */
    private refreshWorkspaceDependencies;
    forgetResolution(descriptor: Descriptor): void;
    forgetResolution(locator: Locator): void;
    forgetTransientResolutions(): void;
    forgetVirtualResolutions(): void;
    getDependencyMeta(ident: Ident, version: string | null): DependencyMeta;
    findLocatorForLocation(cwd: PortablePath): Promise<Locator | null>;
    validateEverything(opts: {
        validationWarnings: Array<{
            name: MessageName;
            text: string;
        }>;
        validationErrors: Array<{
            name: MessageName;
            text: string;
        }>;
        report: Report;
    }): Promise<void>;
    resolveEverything(opts: {
        report: Report;
        lockfileOnly: true;
        resolver?: Resolver;
    } | {
        report: Report;
        lockfileOnly?: boolean;
        cache: Cache;
        resolver?: Resolver;
    }): Promise<void>;
    fetchEverything({ cache, report, fetcher: userFetcher }: InstallOptions): Promise<void>;
    linkEverything({ cache, report, fetcher: optFetcher }: InstallOptions): Promise<void>;
    install(opts: InstallOptions): Promise<void>;
    generateLockfile(): string;
    persistLockfile(): Promise<void>;
    persistInstallStateFile(): Promise<void>;
    restoreInstallState(): Promise<void>;
    applyLightResolution(): Promise<void>;
    persist(): Promise<void>;
    cacheCleanup({ cache, report }: InstallOptions): Promise<void>;
}
